/***************************************************************************
 *                                                                         *
 *   ISFILN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for determining if a character is       *
 *   valid as part of a DOS filename.  The filename as constituted so      *
 *   far is passed so that acceptance of a period ('.') can be made        *
 *   conditional on whether or not one already appears.  Handily enough,   *
 *   this makes isfiln() perfect for use as an edtval() validation         *
 *   function when entering a filename.                                    *
 *                                                                         *
 *                                            - T. Stryker 3/24/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

GBOOL                              /*   returns TRUE=valid FALSE=invalid   */
isfiln(                            /* is c/stg a valid file character/stg  */
INT c,                             /*   character to check                 */
CHAR *stg)                         /*   string to check                    */
{
     if (c == '.') {
          return((strchr(stg,'.') == NULL) ? TRUE : FALSE);
     }
     return(isvalfc((CHAR)c));
}
