/***************************************************************************
 *                                                                         *
 *   INISCN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for loading a binary screen image       *
 *   file into a memory buffer (or directly onto the screen).              *
 *                                                                         *
 *                                            - T. Stryker 2/5/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

VOID
iniscn(                            /* initialize a screen from screen file */
CHAR *filnam,                      /*   filename to load                   */
VOID *where)                       /*   buffer to place file image         */
{
     FILE *fp;
     static CHAR savscn[GVIDSCNSIZ];

     if ((fp=fopen(filnam,FOPRB)) == NULL) {
          catastro("INISCN UNABLE TO OPEN \"%s\" FOR INPUT",filnam);
     }
     if (where == 0) {
          if (fread(savscn,GVIDSCNSIZ,1,fp) != 1) {
               catastro("INISCN ERROR READING \"%s\"",filnam);
          }
          mem2scn(savscn,0,GVIDSCNSIZ);
     }
     else if (fread(where,GVIDSCNSIZ,1,fp) != 1) {
          catastro("INISCN ERROR READING \"%s\"",filnam);
     }
     cvtscn(where);
     fclose(fp);
}
