/***************************************************************************
 *                                                                         *
 *   IBM2ANS.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for converting IBM color display        *
 *   attribute bytes to ANSI sequences.                                    *
 *                                                                         *
 *                                            - R. Stein   2/7/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

                      /* reentrant - can be called by interrupt or mainline */
CHAR *                             /*   returns ptr to buff                */
ibm2ans(                           /* cvt IBM color disp attr to ansi seq  */
CHAR attr,                         /*   IBM display attribute 00-FF        */
CHAR *buff)                        /*   max lgth of output: 14 bytes + term*/
{
     static CHAR clrtab[]={'0','4','2','6','1','5','3','7'};
     INT colour;
     CHAR *bp;

     bp=buff;
     *bp++='\033';
     *bp++='[';
     *bp++='0';
     if (attr == 0x70) {
          *bp++=';';
          *bp++='7';
     }
     else {
          if ((attr&0x80) != 0) {
               *bp++=';';
               *bp++='5';
          }
          if ((attr&0x08) != 0) {
               *bp++=';';
               *bp++='1';
          }
          if ((colour=attr&0x07) != 0x00) {
               *bp++=';';
               *bp++='3';
               *bp++=clrtab[colour];
          }
          if ((colour=(attr&0x70)>>4) != 0x07) {
               *bp++=';';
               *bp++='4';
               *bp++=clrtab[colour];
          }
     }
     *bp++='m';
     *bp='\0';
     return(buff);
}

