/***************************************************************************
 *                                                                         *
 *   GETRNO.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine to return the system's registration     *
 *   number.                                                               *
 *                                                                         *
 *                                                - C. Dunn 1/12/95        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

#define REGSTR "ReG#"              /* reg number prefix in GALGSBL.DLL     */
#define RNOSIZ 9                   /* maximum length of registration no.   */

CHAR *                             /*   return pointer to registration no. */
getrno(VOID)                       /* gets system registration number      */
{
     CHAR ch,fname[20];
     INT match=0;
     FILE *fp;
     static CHAR regnum[RNOSIZ];

#ifdef UNIX
     strcpy(fname,"libunix/gsbl.o");
#else
     strcpy(fname,"GALGSBL.DLL");
#endif
     if ((fp=fopen(fname,FOPRB)) == NULL) {
          catastro("GETRNO: Error opening %s for input.",fname);
     }
     while (!feof(fp)) {
          ch=fgetc(fp);
          if (ch == REGSTR[match]) {
               match++;
          }
          else {
               match=0;
          }
          if (match == strlen(REGSTR)) {
               if (fread(regnum,1,RNOSIZ-1,fp) != 8) {
                    catastro("GETRNO: Error reading %s!",fname);
               }
               regnum[RNOSIZ-1]='\0';
               fclose(fp);
               return(regnum);
          }
     }
     catastro("GETRNO: Cannot locate registration number.");
     return(NULL);
}
