/***************************************************************************
 *                                                                         *
 *   GENDPK.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for the generic dynapak database routine      *
 *   suite in GCOMM.LIB.                                                   *
 *                                                                         *
 *                                            - C. Robert   1/17/94        *
 *                                              T. Stryker                 *
 *                                                                         *
 ***************************************************************************/

#ifndef __GENDPK_H
#define __GENDPK_H


#if ! defined( __WGCLIENT )

#include "gcsp.h"

#if defined( __cplusplus )
extern "C" {
#endif

extern DFAFILE *gdpbb;             // generic dynapak database Btrieve ptr 

struct gdprec {                    // generic dynapak Btrieve record layout
     struct saunam name;           //   dynapak name                       
     CHAR value[1];                //   dynapak value                      
};

#define GDPBTR      ((struct gdprec *)gdpbb->data)

VOID
opngdp(VOID);                      // open the generic dynapak database    

USHORT                             //   return number of bytes read        
readgdpEQ(                         // read dnp from GDP db w/ conversion   
struct saunam *name,               //   dpk to read and dest for name read 
USHORT length,                     //   length of passed dest buffer       
VOID *dest,                        //   destination (NULL=leave in GDPBTR) 
struct flddef *fda);               //   field def. array                   

USHORT                             //   return number of bytes read        
readgdpGT(                         // read dnp from GDP db w/ conversion   
struct saunam *name,               //   dpk to read and dest for name read 
USHORT length,                     //   length of passed dest buffer       
VOID *dest,                        //   destination (NULL=leave in GDPBTR) 
CHAR *suffix,                      //   suffix for minimal match           
struct flddef *fda);               //   field def. array                   

USHORT                             //   return number of bytes read        
readgdpLT(                         // read dnp from GDP db w/ conversion   
struct saunam *name,               //   dpk to read and dest for name read 
USHORT length,                     //   length of passed dest buffer       
VOID *dest,                        //   destination (NULL=leave in GDPBTR) 
CHAR *suffix,                      //   suffix for minimal match           
struct flddef *fda);               //   field def. array                   

VOID
writegdp(                          // write dnp to the GDP db w/ conversion
struct saunam *name,               //   name of dynapak to write           
USHORT length,                     //   length of dynapak value            
VOID *value,                       //   pointer to dynapak value           
struct flddef *fda);               //   field def. array                   

VOID
clsgdp(VOID);                      // close the generic dynapak database   


#if defined( __cplusplus )
}   // end extern "C"
#endif

#endif // __WGCLIENT


#endif // __GENDPK_H