/***************************************************************************
 *                                                                         *
 *   GCOMMLIB.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This file defines the necessary data types, prototypes and functions  *
 *   used in the MSVC version of GCOMM.LIB for developing C++ applications.*
 *                                                                         *
 *                                 - Joe Delekto  7/24/96                  *
 *                                                                         *
 ***************************************************************************/

#ifndef __GCOMMLIB_H
#define __GCOMMLIB_H

#define VC_EXTRALEAN          // Excluded rarely used windows stuff

#define EXPWGSV(x)            extern x
#define EXPWGSF(t,x)          extern t (* x)
#define IMPORT_VARIABLE(x)    extern x

#if !defined(WGSEXP)
#  define WGSEXP
#endif

#include <assert.h>

#include <io.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <direct.h>
//#include <iostream.h>
#include <memory.h>
#include <process.h>
#include <errno.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <setjmp.h>
#include <sys/stat.h>
#include <windows.h>
#include "wgstypes.h"
#include "cfgapi.h"
#include "cvtapi.h"
#include "dfaapi.h"
#include "dntapi.h"
#include "fioapi.h"
#include "audapi.h"
#include "kbdapi.h"
#include "mcvapi.h"
#include "keyapi.h"
#include "vidapi.h"
#include "msgrdr.h"
#include "datstm.h"
#include "tfscan.h"
#include "vbdatim.h"
#include "gccuros.h"
#include "elogapi.h"
#include "wgsmsgs.h"
#include "lingo.h"
#include "elogapi.h"
#include "phasedbg.h"
//#include "excphand.h"
#include "gendpk.h"
#include "gcwinver.h"


//   Server name definitions for WebCast vs. Worldgroup
//
#include "server.h"

//   "unable to proceed" message
//
#define NOPROCEED "\nUnable to proceed, another " SVR_NAME " process is active."


#define DllExport __declspec(dllexport)
#define DllImport __declspec(dllimport)

#define CHAN_NUL    -1

#define FOPRB  "rb"
#define FOPWB  "wb"

#define DELIMS ", \t;"

                                   // flags for edtval() routine
#define MCHOICE     1              //   multi-choice question, hide cursor
#define ALLCAPS     2              //   convert chars to capital letters
#define USEPOFF     4              //   use proff() x,y base coord offsets
#define MULTIEX     8              //   allow multi field-exit conditions

#ifndef abs
#define abs(a)          (((a) < 0) ? -(a) : (a))
#endif

#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif

#ifndef max
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#endif

#define updcrc(cp,crc) (crctab[((crc>>8)&255)]^(crc<<8)^cp)
#define UPDC32(b,c) (cr3tab[((short)c^b)&0xff]^((c>>8)&0x00FFFFFFL))

#define CRC32GOOD 0xDEBB20E3L

extern LONG cr3tab[];
extern USHORT crctab[];

                                   // function redefinitions for compat.
#define sstatr(a)  setatr(a)       // redirected for monochrome CRT support
#define ltoa(a)    l2as(a)         // redirected to ensure compatibility
#ifndef setmem
#define setmem(p,n,c)  memset(p,c,n)
#endif

#if !defined( movmem )
#  define movmem(s,d,l)  memmove(d,s,l)
#endif

#define nelems(x) (sizeof(x)/sizeof(x[0]))   // # of elements in an array

#define VBTRUE  ((GBOOL)(0xFFFF))            // Visual Basic TRUE
#define VBOOL2C(x) if (x != FALSE) x=TRUE
#define CSTRLEN(stringConstant) (sizeof(stringConstant)-1)
#define NULSTR(s) ((s) == NULL || *(s) == '\0')
#define MARKSOURCE(filename) VOID DllExport __##filename(VOID){}

#define CHAN_NUL  -1               // "no channel" value

#if defined( __cplusplus )
extern "C" {
#endif

extern CHAR *pinstd;               // ptr error message string for bad ptrs

extern INT explodem;               // yes/no controlling exploding windows
extern INT edtvalc;                // last char accepted by edtval()

extern INT pxoff;
extern INT pyoff;

extern SHORT selatr;
extern SHORT nslatr;
extern SHORT curchc;
extern SHORT fstchc;

extern SHORT bgperc;
extern SHORT bgpos;

extern ULONG nmfree;
extern ULONG nmalloc;


VOID *alcblok(USHORT,USHORT);
VOID *ptrblok(VOID *,USHORT);
CHAR *alcdup(const CHAR *stg);
VOID *alcmem(size_t);
VOID *alcrsz(VOID *,size_t,size_t);
VOID *alczer(size_t);
GBOOL alldgs(const CHAR *);
GBOOL allhex(const CHAR *);
VOID galastfail(CHAR *,ULONG,CHAR *);
VOID b2ccpy(CHAR *,const CHAR *,size_t);
CHAR *b2ccvt(CHAR *,INT);
CHAR *bargph(SHORT,LONG,LONG);
SHORT bigdigit(const CHAR *,SHORT,SHORT,SHORT);
VOID c2bcpy(CHAR *,const CHAR *,UINT);
CHAR *c2bcvt(CHAR *,INT);
VOID catastro(CHAR *,...);
VOID memcata(VOID);
VOID cataexit(VOID);
CHAR *catfix1(VOID);
SHORT choose(SHORT,CHAR **,SHORT,SHORT,SHORT,SHORT,GBOOL);
SHORT choowd(CHAR **,SHORT,SHORT,SHORT,SHORT,SHORT,GBOOL);
VOID supchc(SHORT,CHAR **,SHORT,SHORT,SHORT,SHORT,GBOOL);
SHORT choout(VOID);
SHORT hdlchc(SHORT);
VOID dspchc(VOID);
VOID jmp2chc(SHORT);
CHAR *commas(CHAR *);
VOID ctrlbrk(INT (*)(VOID));
CHAR *cvtscn(VOID *);
SHORT depad(CHAR *);
INT newarr(INT,UINT);
VOID *add2arr(INT,VOID *);
VOID *arrbas(INT);
INT ninarr(INT);
VOID *arrelem(INT,INT);
VOID inipool(CHAR *);
INT newpool(UINT,INT,INT);
INT rsvarea(INT);
VOID *areaptr(INT,INT);
VOID unrarea(INT,INT);
VOID clspool(VOID);
INT edtchc(INT,INT,CHAR *,CHAR **,INT);
GBOOL edtval(INT,INT,INT,CHAR *,GBOOL (*)(INT,CHAR *),INT);
VOID explode(CHAR *,INT,INT,INT,INT);
VOID explodeto(CHAR *,INT,INT,INT,INT,INT,INT);
VOID nsexploto(CHAR *,INT,INT,INT,INT,INT,INT);
INT fgetstg(CHAR *,INT,FILE *);
INT findstg(CHAR *,CHAR *);
CHAR *firstwd(CHAR *);
CHAR *nextwd(VOID);
USHORT crc16(const CHAR *,UINT);
ULONG crc32(const CHAR *,UINT);
GBOOL goodptr(VOID *);
GBOOL goodstg(CHAR *);
UINT goodblk(VOID *,UINT);
VOID *galmalloc(UINT);
VOID galfree(VOID *);
VOID memdbgrpt(FILE *);
VOID gcdelay(ULONG);
CHAR *getasc(INT);
VOID prfasc(INT,...);
CHAR *ibm2ans(CHAR,CHAR *);
VOID iniscn(CHAR *,VOID *);
VOID dsairp(VOID);
VOID enairp(VOID);
GBOOL isbigend(VOID);
GBOOL isfiln(INT,CHAR *);

#if defined( __cplusplus )
GBOOL isrunpgm(Cffblk *,CHAR *);
#endif

GBOOL isselc(INT);
GBOOL istxvc(INT);
GBOOL isuidc(INT);
CHAR *itemidxd(const CHAR *,INT,const CHAR *);
CHAR *itemidx(const CHAR *,INT);
INT itemcntd(const CHAR *,const CHAR *);
INT itemcnt(const CHAR *ctlstg);
CHAR *l2as(LONG);
CHAR *ul2as(ULONG);
CHAR *lastwd(CHAR *);
CHAR lingyn(CHAR);
CHAR *catfix2(VOID);
CHAR *mdfgets(CHAR *,INT,FILE *);
CHAR *gmdnam(CHAR *);
INT gnumdb(CHAR *);
VOID snumdb(CHAR *,INT);
CHAR *scnmdf(CHAR *,CHAR *);
CHAR *mdfodmd(CHAR *);
INT memstp(CHAR *,INT,CHAR);
VOID inimlt(UINT);
VOID clrmlt(VOID);
VOID cklonl(VOID);
VOID outmlt(INT);
CHAR *msgscan(CHAR *,CHAR *);
CHAR *mstscan(CHAR *,CHAR *,INT);
GBOOL needupc(VOID);
INT noalen(CHAR *);
VOID padfld(CHAR *,INT);
VOID pascrit(VOID);
VOID prfmlt(INT,...);
VOID pmlt(CHAR *,...);
VOID iniprf(CHAR *,INT);
VOID outprf(INT);
VOID prf(CHAR *,...);
VOID prfmsg(INT,...);
VOID clrprf(VOID);
INT profan(CHAR *);
INT readpfn(const CHAR *,CHAR **);
VOID repmem(VOID *,CHAR *,INT);
VOID rmvwht(CHAR *);
VOID rtkick(INT,VOID (*)(VOID));
VOID prcrtk(VOID);
GBOOL sameas(const CHAR *,const CHAR *);
GBOOL samein(const CHAR *,const CHAR *);
GBOOL samend(const CHAR *,const CHAR *);
GBOOL sameto(const CHAR *,const CHAR *);
UINT scanch(const CHAR *,CHAR,INT);
UINT scanstg(const CHAR *,const CHAR *,INT);
UINT scanmem(const CHAR *,const CHAR *,INT,INT);
VOID setcnf(CHAR *,CHAR *);
VOID applyem(CHAR *);
VOID setcrit(VOID);
GBOOL isfxval(UINT *,CHAR *);
GBOOL lsfxval(ULONG *,CHAR *);
ULONG sizmem(VOID);
CHAR *skpans(CHAR *);
CHAR *skpwht(const CHAR *);
CHAR *skptwht(const CHAR *);
CHAR *skpwrd(CHAR *);
VOID sortstgs(CHAR **,INT);
CHAR *spr(CHAR *,...);
INT stgidx(CHAR *,CHAR);
CHAR *stlcpy(CHAR *,const CHAR *,UINT);
CHAR *stlcat(CHAR *,const CHAR *,UINT);
CHAR *stpans(CHAR *);
CHAR *stpcpy(CHAR *,const CHAR *);
CHAR *strins(CHAR *,CHAR *,INT);
INT strpln(const CHAR *);
CHAR *strrpl(CHAR *,CHAR,CHAR);
GBOOL strsrep(CHAR *,CHAR *,CHAR *);
CHAR *strstp(CHAR *,CHAR);
CHAR *stzcpy(CHAR *,const CHAR *,UINT);
CHAR *stzcat(CHAR *,const CHAR *,UINT);
VOID opnsysinf(VOID);
VOID clssysinf(VOID);
INT initask(VOID (*)(INT));
VOID mfytask(INT,VOID (*)(INT));
VOID prctask(VOID);
GBOOL undwin(VOID);
CHAR *unpad(CHAR *);
GBOOL validig(INT);
GBOOL validyn(INT,CHAR *);
GBOOL wcmatch(CHAR *,CHAR *);
GBOOL canRunWGS(VOID);
GBOOL canRunGroup(VOID);
GBOOL canRunUtil(VOID);
GBOOL canRunWGSINT(VOID);
GBOOL canRunWGSCNF(VOID);
GBOOL allowWGSINT(VOID);
VOID insdbz(VOID);
VOID freekey(VOID);
GBOOL isWinNT(VOID);
CHAR *getErrorText(ULONG,CHAR *,ULONG);
CHAR *getLastErrorText(CHAR *,ULONG);


                                   /* defines for assertion failure mode   */
#define ASTIGN 1                   /*   ignore                             */
#define ASTRPT 2                   /*   make report to disk (see astrptfil)*/
#define ASTCAT 3                   /*   call catastro(), shut down immed.  */

extern SHORT catact;

#if !defined( ASSERT )
#    if defined( DEBUG )
#         define ASSERT(cnd) ((cnd) ? ((VOID)0) \
               : galastfail(__FILE__" "FILREV,__LINE__,#cnd));
#         define ASSERTM(cnd,msg) ((cnd) ? ((VOID)0) \
                 : galastfail(__FILE__" "FILREV,__LINE__,msg));
#    else    // DEBUG
#         define ASSERT(c)    ((VOID)0)
#         define ASSERTM(c,m) ((VOID)0)
#    endif  /* DEBUG */
#endif  /* ASSERT */

VOID
freblok(                           /* free region allocated with alcblok() */
VOID *bigptr);                     /*   alcblok() return value             */

VOID *                             /*   returns ptr to buffer              */
memrpl(                            /* replace bytes in a buffer            */
VOID *buf,                         /*   buffer to do replacing in          */
CHAR oldByte,                      /*   byte to replace                    */
CHAR newByte,                      /*   new byte                           */
size_t bufSiz);                    /*   size of buffer                     */

CHAR *                             /*   returns copy of ptr to dest        */
strmove(                           /* move string w/overlapping src/dest   */
CHAR *dst,                         /*   destination                        */
const CHAR *src);                  /*   source                             */

CHAR *                             /*   ptr to first char on line or NULL  */
nextLine(                          /* find next line in a string           */
const CHAR *str,                   /*   string to search                   */
const CHAR *eol);                  /*   end-of-line marker string          */

INT
hexval(                            /* get hexadecimal value from digit     */
CHAR dig);                         /*   hexadecimal digit to convert       */

CHAR
hexdig(                            /* get hexadecimal value from digit     */
UINT val);                         /*   value to convert                   */

typedef                                                                      \
INT                                /*   > 0 = target > test, etc.          */\
(*binSearchComp)(                  /* binary search util comparison func   */\
const VOID *target,                /*   target object                      */\
const VOID *array,                 /*   array object                       */\
ULONG index);                      /*   index of array element to test     */

ULONG                              /*   index or numElems if not found     */
binSearch(                         /* generic binary search utility        */
const VOID *target,                /*   target object to find              */
const VOID *array,                 /*   array object                       */
ULONG numElems,                    /*   number of elements in array object */
binSearchComp compFunc);           /*   comparison function                */

ULONG                              /*   index where element should be      */
binFindNear(                       /* generic binary find nearest utility  */
INT *lastComp,                     /*   result of last comparison          */
const VOID *target,                /*   target object                      */
const VOID *array,                 /*   array object                       */
ULONG numElems,                    /*   number of elements in array object */
binSearchComp compFunc);           /*   comparison function                */

#if defined( __cplusplus )
}
#endif

#endif
