/***************************************************************************
 *                                                                         *
 *   GALMEMDB.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the GCOMM.LIB routines for memory allocation which also     *
 *   support debugging.                                                    *
 *                                                                         *
 *                                  - R. Stein & D. Pitchford 1/25/95      *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

#undef malloc                      // undo #define malloc in gcomm.h
#undef free                        // undo #define free in gcomm.h

#define GBGBYT  (0xA3)             // garbage byte for uninitialized memory
#define DTHRESH 0xF000U            // sel at which to avert specials       

#ifdef DEBUG
GBOOL memdbg=TRUE;                 // set FALSE to disable special sel dbg 
GBOOL alcdbg=TRUE;                 // (memdbg) FALSE= low on selectors     
#else
GBOOL memdbg=FALSE;                // ditto                                
GBOOL alcdbg=FALSE;                // ditto                                
#endif

ULONG nmalloc=0L;                  // count malloc()'s                     
ULONG nmfree=0L;                   // count free()'s                       
UINT lstalcsiz;                    // size of last successful malloc()     

VOID *                             //   returns ptr to newly alloc'd space 
galmalloc(                         // Galacticomm's malloc() for debugging 
UINT size)                         //   size to malloc()                   
{
     VOID *rc;

// HACK ASSERTM Here
//     ASSERTM(size != 0,"Can't allocate zero bytes with malloc()!");
     rc=malloc(size);
     if (rc != NULL) {
          nmalloc++;
          lstalcsiz=size;
     }
     return(rc);
}

VOID
galfree(                           // Galacticomm's free() for debugging   
VOID *block)                       //   ptr to block to free()             
{
#ifdef DEBUG
     ASSERTM(block != NULL,"Can't free() a NULL pointer!");
#endif // DEBUG
     free(block);
     nmfree++;
}

VOID
memdbgrpt(                         // report on special memory debugging   
FILE *fp)                          //   open file to report to             
{
     fprintf(fp,"%lu memory blocks allocated.\n",nmalloc);
     fprintf(fp,"%lu memory blocks freed.\n",nmfree);
}