/***************************************************************************
 *                                                                         *
 *   FIRSTWD.C                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for finding the first word in a         *
 *   string.  A word longer than 300 characters will be truncated.          *
 *   After calling firstwd(), successive calls to nextwd() will            *
 *   return copies of the remaining words.  (The original string           *
 *   passed to firstwd() must stay intact, and no calls to firstwd()       *
 *   can intervene.)                                                       *
 *                                                                         *
 *   Example usage:                                                        *
 *                                                                         *
 *        char *wrd;                                                       *
 *                                                                         *
 *        for (wrd=firstwd(string) ; *wrd != '\0' ; wrd=nextwd()) {        *
 *             dosomethingwith(wrd);                                       *
 *        }                                                                *
 *                                                                         *
 *                                            - R. Stein 1/14/93           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

#define FWMAX 300

static CHAR fwbuf[FWMAX+1];
static CHAR *fwlast;

CHAR *                             /*   returns ptr to first word          */
firstwd(                           /* find first word of a string          */
CHAR *string)                      /*   returns a copy of it, or "" if none*/
{
     fwlast=string;
     return(nextwd());
}

CHAR *                             /*   returns word or "" when done       */
nextwd(VOID)                       /* find next word in string             */
{
     CHAR c;
     INT i;

     fwlast=skpwht(fwlast);
     for (i=0 ; (c=*fwlast) != '\0'
                && !isspace(c)
                && i < FWMAX ; fwlast++,i++) {
          fwbuf[i]=c;
     }
     fwbuf[i]='\0';
     return(fwbuf);
}
