/***************************************************************************
 *                                                                         *
 *   FIOAPI.H                                                              *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   File I/O API subsystem.                                               *
 *                                                                         *
 *                                        - Craig Yap        01/15/96      *
 *                                        - Richard Skurnick 01/15/96      *
 *                                        - Ilya Minkin      01/15/96      *
 *                                                                         *
 ***************************************************************************/

#ifndef __FIOAPI_H
#define __FIOAPI_H

#include <share.h>

#if defined( __cplusplus )
extern "C" {
#endif
                                   // OS defines
#define SL            '\\'
#define SLS           "\\"
#define STAR          "*.*"
#define STR_EOL       "\r\n"
#define CHR_EOL       '\r'
#define MKDIR(dir)    _mkdir(dir)

#define MAXPATH     _MAX_DRIVE+_MAX_DIR+_MAX_FNAME+_MAX_EXT
#define DRIVE       0x01
#define DIRECTORY   0x02
#define FILENAME    0x04
#define EXTENSION   0x08
                                   // fopen() 2nd parameter
#define FOPRA  "rt"                // read ASCII mode
#define FOPWA  "wt"                // write ASCII mode
#define FOPRWA "r+t"               // read/write ASCII mode
#define FOPWRA "w+t"               // write/read ASCII mode
#define FOPAA  "at"                // append ASCII mode

#define FOPRB  "rb"                // read binary mode
#define FOPWB  "wb"                // write binary mode
#define FOPRWB "r+b"               // read/write binary mode
#define FOPWRB "w+b"               // write/read binary mode
#define FOPAB  "ab"                // append binary mode

#define GCSTRPTH 261               // For storage in databases of path+file
#define GCMAXPTH 261               // For data entry
#define GCSTRFNM 64                // For storage in databases
#define GCMAXFNM 13                // in use for WG 2.0 only

#define GCMAXFILE 8                // max file name w/o extension and dot
#define GCMAXEXT  3                // max extension w/o dot

                                   // File Attr Masks (used by fnd1st())
#define FAMRON 0x01                // read only
#define FAMHID 0x02                // hidden
#define FAMSYS 0x04                // system
#define FAMVID 0x08                // volume id
#define FAMDIR 0x10                // sub-directory
#define FAMARC 0x20                // archive

extern CHAR deldirerr[GCMAXPTH+40];// error message when deldir() != 0

                                   //   for filxxxlst() functions
#define MAXFLL 60                  //   max length of download file list
#define MAXFLP 60                  //   max length of fll1st() path

#define BLKSIZ 512                 // maximum copy block size
#define CPBSIZ 16384               // maximum size for copy buffer (DOS)

#if defined( __cplusplus )

class Cffblk {
public:
     Cffblk();
     ~Cffblk();
public:
     HANDLE    ff_handle;          //   handle used by _findfirst/_findnext
     WIN32_FIND_DATA nfblock;      //   new file information block
     UINT      s_attrib;           //   attribute for subsequent searches
     LONG      ff_reserved;        //   reserved part of ffblk
     LONG      ff_fsize;           //   file size portion of ffblk
     UINT      ff_attrib;          //   attribute part of ffblk
     USHORT    ff_ftime;           //   time portion of ffblk
     USHORT    ff_fdate;           //   date portion of ffblk
     CHAR      ff_name[260];       //   filename portion of ffblk
};

struct filblklst { // fil1stlst()/filnxtlst() file-list scanning structure
     Cffblk fb;                    //   structure used by fnd1st()/fndnxt()
     CHAR list[MAXFLL+1];          //   list of files
     CHAR pathpf[MAXFLP+1];        //   path prefix for each file
};

#endif

extern LONG ztzone;                // Seconds between GMT and local time

                                   // global vars set by cntdir()/cntdirs()
extern LONG numfils;               // total number of files
extern LONG numbyts;               // total number of bytes
extern LONG numbytp;               // # bytes + wasted part of last cluster
extern LONG numdirs;               // total number of subdirectories

                                   // defines for the fileparts() function
#define GCPART_PATH 0              //   drivespec and path
#define GCPART_FNAM 1              //   filename w/ ext
#define GCPART_FILE 2              //   filename w/o ext
#define GCPART_EXTN 3              //   extension only
#define GCPART_DRVS 4              //   drivespec only

CHAR *                             //   returns pointer to dstbuf or ""
fileparts(                         // grab required part of a full filename
SHORT filpart,                     //   part to be returned
const CHAR *fullname,              //   full filename to be worked on
CHAR *dstbuf,                      //   destination buffer for data
SHORT dstsiz);                     //   destination buffer size

GBOOL                              //   returns TRUE=copy successful
cpyutl(                            // copy file utility
const CHAR *src,                   //   source file name
const CHAR *dst,                   //   destination file names
const CHAR *srcmod,                //   source fopen() mode
const CHAR *dstmod);               //   destination fopen() mode

GBOOL                              //   returns TRUE if one found
filspclst(                         // any files in the first filespec?
struct filblklst *flp);            //   path and file list to search

GBOOL                              //   returns TRUE if found
fil1stlst(                         // find first file in a list
struct filblklst *flp,             //   struct for continuing w/ filnxtlst
const CHAR *prefix,                //   path prefix
const CHAR *list);                 //   list of files/path

GBOOL                              //   returns TRUE if one found
filnxtlst(                         // find next file in list
struct filblklst *flp);            //   previous filblklst to cont. search

VOID
cntdir(                            // count bytes and files in a directory
const CHAR *path);                 //   path name of the directory contents

VOID
cntdirs(                           // count bytes/files in dir & its subdir
const CHAR *path);                 //   path name of the directory contents

LONG                               //  returns total file size
clfit(                             // figure size of file including waste
LONG size,                         //   file size in bytes
USHORT clsiz);                     //   size of clusters on this drive

UINT                               //   returns size or 0 for error
clsize(                            // get cluster size in bytes
const CHAR *path);                 //   path to drive to check

GBOOL                              //   returns TRUE=file updated
setFileTm(                         // set file time & date
const CHAR *fname,                 //   file name
USHORT dtim,                       //   time to set
USHORT ddat);                      //   date to set

GBOOL                              //   returns TRUE=file updated
setFileGMT(                        // set file time and date
const CHAR *fname,                 //   file name
ULONG gmt70);                      //   time in sec since 00:00 1/1/70 GMT

VOID
getFileTm(                         // get time and date for file
const CHAR *fname,                 //   file name
USHORT *dtim,                      //   time to get
USHORT *ddat);                     //   date to get

ULONG                              //   returns time and date in GMT format
getFileGMT(                        // get GMT file time and date
const CHAR *fname);                //   file name

LONG                               //   returns kbytes free or -1 for error
dskfre(                            // number of kbytes free on a drive
const CHAR *path);                 //   path on drive to check,NULL=default


#if defined( __cplusplus )

GBOOL                              //   returns TRUE=found a file
fnd1st(                            // find file matching filspc and attr
Cffblk *fbptr,                     //   ptr to data storage area
const CHAR *filspc,                //   file spec to match
UINT attr);                        //   attribute to match

GBOOL                              //   returns TRUE=found a file
fndnxt(                            // find next file matching filspc & attr
Cffblk *fbptr);                    //   ptr to data storage area

GBOOL                              /*   TRUE if matching file found        */
fndfile(                           /* check file's existence and stats     */
Cffblk *fb,                        /*   file info (CLOSED after findfirst) */
const char *fname,                 /*   filespec we're searching for       */
UINT attr);                        /*   attribute(s) to match              */

#endif

GBOOL                              /*   TRUE if dir matching dname exists  */
isdir(                             /* check whether a directory exists     */
const CHAR *dname);                /*   directory name to search for       */

GBOOL                              /*   TRUE if matching file exists       */
isfile(                            /* check for existence of file(s)       */
const CHAR *fname);                /*   filename or wildcard to check      */

CHAR *                             //   returns converted file name
mkdosn(                            // convert string to DOS file name
const CHAR *string);               //   file name to convert to DOS format

VOID
fixpth(                            // add a backslash to string if needed
CHAR *path);                       //   path to append

GBOOL                              //   TRUE=ok FALSE=err, see deldirerr[]
deldir(                            // delete a subdirectory & all contents
const CHAR *dirpath);              //   name of a directory

CHAR *                             //   returns unique file name
uniqfn(                            // create a unique filespec
CHAR *fspec);                      //   original file specification

CHAR *                             //   returns unique file name
ll_uniqfn(                         // low-level routine for unique fspec
GBOOL cataonerr,                   //   catastro() on errors?
CHAR *fspec);                      //   original file specification

CHAR *                             //   copy of pointer to dest
normspec(                          // normalize filespec to complete path
CHAR *dest,                        //   dest buffer (must be GCMAXPTH long)
const CHAR *src);                  //   path+file name to normalize

VOID
gmkdir(                            // recursive version of mkdir()
const CHAR *dirnam);               //   directory name to create

CHAR *                             //   returns ptr to cvt'd fname
fnmcse(                            // handles filenames before use in code
CHAR *fname);                      //   filename to work on

GBOOL                              //   return TRUE=reserved
rsvnam(                            // is a name reserved by OS for a device
const CHAR *name);                 //   name to check

GBOOL                              //   returns TRUE=file moved
movefile(                          // move file(s) from src to dest
const CHAR *src,                   //   source file spec
const CHAR *dest);                 //   destination file spec

GBOOL                              //   returns TRUE=file copied
copyfile(                          // copy file(s) from src to dest
const CHAR *src,                   //   source file spec
const CHAR *dest);                 //   destination file spec

#define GCF_OK  0x0                //   file exists
#define GCX_OK  0x01               //   execute or search permission
#define GCW_OK  0x02               //   write permission
#define GCR_OK  0x04               //   read permission
#define GCRW_OK 0x06               //   read/write permission

                                   // defines for gcfsopen
#define  GSH_COMPAT   _SH_COMPAT   // sets compatiblity mode
#define  GSH_DENYRW   _SH_DENYRW   // deny read/write access
#define  GSH_DENYWR   _SH_DENYWR   // deny write access
#define  GSH_DENYRD   _SH_DENYRD   // deny read access
#define  GSH_DENYNONE _SH_DENYNO   // permits read/write access
#define  GSH_DENYNO   _SH_DENYNO   // permits read/write access

FILE *                             //   returns FILE pointer or NULL
gcfsopen(                          // opens a file in shared mode
const CHAR *filename,              //   file name to open
const CHAR *mode,                  //   mode to open with
USHORT shflag);                    //   shared mode flags

GBOOL                              //   return TRUE if separator character
isvalds(                           // is this char. a file path separator
CHAR c);                           //   character to test

GBOOL                              //   returns TRUE=valid file name char
isvalfc(                           // is this a valid file name character?
CHAR c);                           //   character to check

GBOOL                              //   returns TRUE=valid file name
isvalfn(                           // check for valid file name
const CHAR *filnam);               //   string to check

GBOOL                              //   returns TRUE=valid directory
isvaldn(                           // verify directory name is ok for OS
const CHAR *dirnam);               //   directory name to check

LONG                               //   returns # of bytes copied
xfrfil(                            // copy from one open file to another
FILE *fromfp,                      //   source file pointer
FILE *tofp,                        //   destination file pointer
LONG nbytes);                      //   max bytes to transfer


#if defined( __cplusplus )

INT findfirst(
const CHAR *filspc,
Cffblk *fbptr,
UINT attr);

INT findnext(
Cffblk *fbptr);

#endif


#if defined( __cplusplus )
}   // end extern "C"
#endif

#endif // __FIOAPI_H
