/***************************************************************************
 *                                                                         *
 *   FINDSTG.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for finding a substring in a larger     *
 *   string and returning the index in the larger string of the byte       *
 *   just past the end of the found string, if any, or 0 otherwise.        *
 *   (This way the result can either be treated as a boolean yes/no,       *
 *   the string was found or it wasn't, or as a position at which to       *
 *   begin looking for a parameter value, as in "KEYWORD=VALUE".)          *
 *                                                                         *
 *                                            - T. Stryker 3/24/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

INT                                /*   returns the index to string        */
findstg(                           /* find a string in a body of text      */
CHAR *stg,                         /*   string to search for               */
CHAR *body)                        /*   text to be searched                */
{
     CHAR *sscan,*bscan,*bsptr,sc,bc;

     for (bscan=body ; *bscan != '\0' ; bscan++) {
          for (sscan=stg,bsptr=bscan ;  ; sscan++,bsptr++) {
               sc=*sscan;
               bc=*bsptr;
               if (sc == '-') {
                    while (bc != '\0' && !isalnum(bc)) {
                         if (sc == '-') {
                              sc=*++sscan;
                         }
                         bc=*++bsptr;
                    }
               }
               if (sc == '\0') {
                    return((INT)(bsptr-body));
               }
               if (tolower(sc) != tolower(bc)) {
                    break;
               }
          }
     }
     return(0);
}
