/***************************************************************************
 *                                                                         *
 *   CVTSCN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for conditionally converting a          *
 *   screen image buffer in memory into its monochrome equivalent, based   *
 *   on the setting of the global variable 'color'.                        *
 *                                                                         *
 *                                            - T. Stryker 2/10/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to where               */
cvtscn(                            /* cvt a screen image, ret its address  */
VOID *where)                       /*   buffer to convert                  */
{
     INT i;
     UINT coffset;
     CHAR chpatr,c,*ptr;

     if (!color) {
          if (where == 0) {
               for (i=0,coffset=1 ; i < GVIDSCNSIZ/2 ; i++,coffset+=2) {
                    chpatr=scngetc(coffset);
                    if ((chpatr&8) == 0) {
                         c=scngetc(coffset-1);
                         if (c == 220 || c == 223) {
                              scnputc(coffset-1,32);
                         }
                    }
                    scnputc(coffset,scncolor(coffset));
               }
          }
          else {
               for (i=0,ptr=((CHAR *)where+1)
                   ; i < GVIDSCNSIZ/2
                   ; i++,ptr+=2) {
                    if ((*ptr&8) == 0) {
                         c=*(ptr-1);
                         if (c == 220 || c == 223) {
                              *(ptr-1)=32;
                         }
                    }
                    *ptr=scncolor(*ptr);
               }
          }
     }
     return(where);
}
