/***************************************************************************
 *                                                                         *
 *   CATAWIN.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *   Copyright (c) 1993 Consensus Systems, Inc.   All Rights Reserved.     *
 *                                                                         *
 *   This is the Windows substitute for CATASTRO.C.  It should be noted    *
 *   that catastro() will simply terminate the current task (which, if     *
 *   called from within a DLL, will not decrement the DLL's load count     *
 *   or perform other shutdown niceties).                                  *
 *                                                                         *
 *                                            - T. Stryker 6/15/93         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

SHORT catact=0;               /* catastrophe count, for ripple-effect stop */

static VOID dblcat(VOID);
static VOID vcatamsg(GBOOL intro,CHAR *string,va_list args);
static VOID dftrpt(CHAR *filnam);

VOID (*catrpt)(CHAR *)=dftrpt;     /* interceptable CATASTRO.TXT report vec*/
                                   /* (not used in CATAWIN.C)              */
VOID *catbpsav;                    /* catastro's saved BP location         */
                                   /* (not used in CATAWIN.C)              */

VOID
catastro(                          /* catastrophe message display utility  */
CHAR *string,                      /*   printf()-style control string      */
...)                               /*   variable arguments                 */
{
     va_list a;

#if ! defined( _MSC_VER )
     catbpsav=MK_FP(_SS,_BP);
#endif
     dblcat();
     va_start(a,string);
     vcatamsg(TRUE,string,a);
     va_end(a);
     cataexit();
}

VOID
memcata(VOID)                      /* out of memory (a kinder, gentler cat)*/
{
#if ! defined( _MSC_VER )
     catbpsav=MK_FP(_SS,_BP);
#endif
     dblcat();
     vcatamsg(FALSE,"There is not enough memory to continue.\n"
                    "Please either reduce your memory requirements\n"
                    "or install more memory, and try again.\n",NULL);
     exit(49);
}

VOID
cataexit(VOID)                     /* catastrophe-exit utility             */
{
     exit(70);
}

static VOID
dblcat(VOID)                       /* check for double-catastrophe         */
{
     if (++catact > 1) {
          vcatamsg(FALSE,"PLEASE REBOOT YOUR COMPUTER",NULL);
          exit(80);
     }
}

static VOID
vcatamsg(                          /* pop up a catastro message box        */
GBOOL intro,                       /*   yak about unrecoverable error 1st  */
CHAR *string,                      /*   printf()-style control string      */
va_list args)                      /*   variable arguments                 */
{
     CHAR *cp,catastg[300];

     if (intro) {
          cp=stpcpy(catastg,"An unrecoverable error has occurred:\n\n");
     }
     else {
          *(cp=&catastg[0])='\0';
     }
     vsprintf(cp,string,args);
     MessageBeep(MB_ICONHAND);
     MessageBox(NULL,catastg,"APP ERROR",MB_ICONSTOP+MB_OK+MB_TASKMODAL);
}

static VOID
dftrpt(                            /* default (*catrpt)() routine          */
CHAR *filnam)
{
     (VOID)filnam;
}
