/***************************************************************************
 *                                                                         *
 *   CATASTVB.C                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *   Copyright (c) 1993 Consensus Systems, Inc.   All Rights Reserved.     *
 *                                                                         *
 *   This is the substitute for CATASTRO.C when using DLLs with Visual     *
 *   Basic.  It generates a VBRuntimeError() call with a message equal     *
 *   to the sprintf() of the one passed.                                   *
 *                                                                         *
 *                                            - T. Stryker 6/22/93         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

#define CATERR 25000               /* fixed catastrophe err number for VB  */
CHAR catastg[300];                 /* holding area for VB err msg string   */
SHORT catact=0;               /* catastrophe count (not used in CATASTVB.C)*/

static VOID vcatamsg(GBOOL intro,CHAR *string,va_list args);
static VOID dftrpt(CHAR *filnam);

VOID (*catrpt)(CHAR *filnam)=dftrpt; /* interceptable catastro reporter    */
                                   /* (not used in CATASTVB.C)             */
VOID *catbpsav;                    /* catastro's saved BP location         */
                                   /* (not used in CATASTVB.C)             */

VOID
catastro(                          /* catastrophe message display utility  */
CHAR *string,                      /*   printf()-style control string      */
...)                               /*   variable arguments                 */
{
     va_list a;

     catbpsav=MK_FP(_SS,_BP);
     catact++;
     va_start(a,string);
     vcatamsg(TRUE,string,a);
     va_end(a);
     cataexit();
}

VOID
memcata(VOID)                      /* out of memory (a kinder, gentler cat)*/
{
     catbpsav=MK_FP(_SS,_BP);
     catact++;
     vcatamsg(FALSE,"There is not enough memory to continue.\n"
                    "Please either reduce your memory requirements\n"
                    "or install more memory, and try again.\n",NULL);
     cataexit();
}

static VOID
vcatamsg(                          /* pop up a catastro message box        */
GBOOL intro,                       /*   yak about unrecoverable error 1st  */
CHAR *string,                      /*   printf()-style control string      */
va_list args)                      /*   variable arguments                 */
{
     CHAR *cp;

     if (intro) {
          cp=stpcpy(catastg,"An unrecoverable error has occurred:\n\n");
     }
     else {
          *(cp=&catastg[0])='\0';
     }
     vsprintf(cp,string,args);
}

static VOID
dftrpt(                            /* default (*catrpt)() routine          */
CHAR *filnam)
{
     (VOID)filnam;
}

#undef CHAR
#undef SHORT
#undef USHORT
#undef ULONG
#include "vbapi.h"

VOID
cataexit(VOID)                     /* catastrophe-exit utility             */
{
     VBRuntimeError(VBSetErrorMessage(CATERR,catastg));
}
