/***************************************************************************
 *                                                                         *
 *   BRKTHU.H                                                              *
 *                                                                         *
 *   Copyright (c) 1986-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file prototyping all of the GSBL routines.         *
 *                                                                         *
 *                                            - T. Stryker 2/12/92         *
 *                                                                         *
 ***************************************************************************/

#ifndef __BRKTHU_H
#define __BRKTHU_H

#ifdef __BUILDGSBL
#define GSBLEXP //__export
#else
#define GSBLEXP //__import
#endif                             // __BUILDGSBL

#include "datstm.h"

#define RING   1              // btusts() return for ringing/lost carrier  
#define CMDOK  2              // btusts() return for command completed ok  
#define CRSTG  3              // btusts() return for CR-term'd string avail
#define INBLK  4              // btusts() return for count-trg input avail 
#define OUTMT  5              // btusts() return for output buffer empty   
#define OBFCLR 6              // btusts() return for output buffer cleared 
#define ABOREQ 7              // btusts() return for abort output requested
#define LOST2C 11             // btusts() return for 2400 baud lost-carrier
#define CMN2OK 12             // btusts() return for 2400 baud cmd complete
#define CMN2NG 13             // uart/hayes cmd byte not executable        
#define LOST25 21             // btusts() return for X.25 lost-carrier     
#define CM25OK 22             // btusts() return for X.25 cmd complete     
#define RCVX29 24             // btusts() return for X.29 string received  
#define SPXTRM 31             // btusts() for SPX terminate by other side  
#define IPXPSE 32             // btusts() for IPX/SPX pause complete       
#define SPXINC 34             // btusts() for SPX incoming call complete   
#define SPXOUT 35             // btusts() for SPX outgoing call complete   
#define SPXTDN 36             // btusts() for SPX termination complete     
#define IPXRER 37             // btusts() for IPX recv error (chan group)  
#define IPXUNK 38             // btusts() for IPX unknown packet (chan grp)
#define SPXWDG 39             // btusts() for SPX watchdog error, etc      
#define INAPP 'I'             // Inappropriate status (fm ^H cmd if 300bd) 
                              // status codes 200-249 are app-specific     
                              // status codes 250-255 are buffer overflow  

#define X25CLO     0x500      // btux29() return code for window-full error

#define SDFANY  0             // GSBL btusdf() argument for XECOM/UART hdw 
#define SDFX25  4             // GSBL btusdf() argument for X.25 hardware  
#define SDFIPXD 5             // GSBL btusdf() argument for IPX Direct hdw 
#define SDFIPXV 6             // GSBL btusdf() argument for IPX Virtual hdw
#define SDFSPX  7             // GSBL btusdf() argument for SPX hardware   
#define SDFGCDI 8             // GSBL btusdf() argument for GCDI channels  

                         // bturep()/btuset() "stid" parameter values      
#define PARITY -9        // parity                                         
#define DATABT -8        // data bits                                      
#define STOPBT -7        // stop bits                                      
#define RSVD01 -6        // reserved                                       
#define CHARIN -5        // character interrupt routine (from btuchi())    
#define PAGDIV -4        // page divider string pointer (from btuxnf())    
#define PAUSCH -3        // handle pause character routine (from btuhpk()) 
#define BAUDRT -2        // baud rate (from btubbr())                      
#define RECNFG -1        // reconfiguration notify routine                 
#define CNTCHR 0         // character count                                
#define CNTPAK 1         // packet count                                   
#define CNTOVR 2         // input overrun count                            
#define CNTPTY 3         // input parity errors                            
#define CNTFMG 4         // input framing errors                           

#define X25ERR -13       // btusdf() return code -- no GSBL/X25 linked     
#define LANERR -14       // btusdf() return code -- LAN access not avail   
#define MEMERR -15       // btuitz()/btusdf() return code -- out of memory 

                         // parity, data bits and stop bits settings       
#define PARNON 0         // no parity                                      
#define PARODD 1         // odd parity                                     
#define PAREVN 2         // even parity                                    
#define DABSVN 2         // 7 data bits                                    
#define DABEGT 3         // 8 data bits                                    
#define STBONE 0         // 1 stop bit                                     
#define STBTWO 2         // 2 stop bits                                    

                              // cdi command modes used by btupcc()        
#define CDIQUE 1              // cdi que, but don't process, commands      
#define CDIQAP 2              // cdi que and process commands              

#define ECHBSZ 512                 // size of echo buffer

extern CHAR GSBLEXP btuver[];      // GSBL version code

extern SHORT GSBLEXP ictact;       // after btuict() or btuica():# byte avl

extern INT GSBLEXP btusrs;         // # users supported under this license 
extern INT GSBLEXP btudtr;         // 1=disable DTR-dropping during reset  
extern INT GSBLEXP btux25;         // flag indicating X.25 support in GSBL 
extern INT GSBLEXP x25ign;         // # of received packets ignored by GSBL
extern INT GSBLEXP x25udt;         // set to 1 to capture User Data Field  
extern INT GSBLEXP lanecb;         // # of listen-ECBs per LAN channel     
extern INT GSBLEXP lansop;         // socket actually opened by btusdf()   
extern INT GSBLEXP lansca;         // SPX connections available            
extern INT GSBLEXP btuicx;         // 'in cdi transmit' flag               

extern CHAR GSBLEXP cdixfn;        // flag to save "sti" in GCDI output sink
                                   // (in CS -- must create DS alias to write)

extern INT GSBLEXP btulan;         // Flags from the GSBL/LAN:             
#define BTLIPXD  0x0001            //    bit 0: IPX Direct supported       
#define BTLIPXV  0x0002            //    bit 1: IPX Virtual supported      
#define BTLSPX   0x0004            //    bit 2: SPX circuits supported     
#define BTLI7A   0x0100            //    bit 8: IPX driver is loaded       
#define BTLSPXL  0x0200            //    bit 9: SPX is loaded              

extern CHAR GSBLEXP  bturno[];     // registration # of this copy of GSBL
extern CHAR GSBLEXP lanrev[2];     // SPX revision number

INT btusiz(INT nchan,INT isiz,INT osiz);
LONG btulsz(INT nchan,INT isiz,INT osiz);
INT btuitz(VOID *region);
INT btuitm(VOID *region);
INT btudef(INT schan,INT sport,INT n);
INT btusdf(INT schan,INT nchan,INT chtype,...);
INT btux29(INT chan,INT nbyt,CHAR *data);
LONG btuset(INT chan,INT stid,LONG newval);
LONG bturep(INT chan,INT stid);
INT btuudf(INT schan,INT n);
INT btumxs(UINT bdrate);
INT bturti(INT n,INT (*rtirou)(VOID));
INT btupfl(VOID (*pflrou)(INT type,UINT off,UINT sel));
extern LONG FAR * GSBLEXP ppflreal;
extern LONG GSBLEXP pflplap;
extern LONG GSBLEXP pflmys3;
extern LONG GSBLEXP pflgsbl;
extern LONG GSBLEXP pflrng3;
extern CHAR GSBLEXP pfn;
INT btubsz(INT chan,INT isiz,INT osiz);
INT btusts(INT chan);
INT btucmd(INT chan,CHAR *cmdstg);
INT btubrt(INT chan,UINT bdrate);
INT btubbr(INT chan,LONG bdrate);
INT btuxmt(INT chan,CHAR *datstg);
INT btuscn(VOID);
INT btuinp(INT chan,CHAR *rdbptr);
VOID btuxlt(CHAR oldchr,CHAR newchr);
INT btupmt(INT chan,CHAR pmchar);
INT btubse(INT chan,CHAR bschar);
INT btutrm(INT chan,CHAR crchar);
INT btuchi(INT chan,CHAR FAR (*rouadr)(INT chan,INT c));
INT btuche(INT chan,INT onoff);
INT btulfd(INT chan,CHAR lfchar);
INT btutsw(INT chan,INT width);
INT btumil(INT chan,INT maxinl);
INT btuscr(INT chan,CHAR softcr);
INT btuhcr(INT chan,CHAR hardcr);
INT btuech(INT chan,INT onoff);
INT btuxnf(INT chan,INT xon,INT xoff,...);
INT btuhwh(INT chan,INT inpcut);
INT btutru(INT chan,CHAR trunch);
INT btuerp(INT chan,INT onoff);
INT btumon(INT chan);
INT btumds(VOID);
VOID btumks(CHAR kyschr);
INT btumon2(INT chan);
INT btumds2(VOID);
VOID btumks2(CHAR kyschr);
INT btuinj(INT chan,INT status);
INT btuoes(INT chan,INT onoff);
INT btuoba(INT chan);
INT btueba(INT chan);
INT btuibw(INT chan);
INT btuxct(INT chan,INT nbyt,CHAR *datstg);
INT btutrg(INT chan,INT nbyt);
INT btuict(INT chan,CHAR *rdbptr);
INT btuica(INT chan,CHAR *rdbptr,INT max);
INT btuffo(INT chan,INT onoff);
INT btulok(INT chan,INT onoff);
INT btuclo(INT chan);
INT btucli(INT chan);
INT btuclc(INT chan);
INT btucls(INT chan);
INT bturst(INT chan);
INT btutrs(INT chan,INT onoff);
INT btupbc(INT chan,CHAR pausch);
INT btucpc(INT chan,CHAR clrpch);
INT btuhpk(INT chan,INT FAR (*hpkrou)(INT chan,CHAR c));
INT btuolk(INT chan,INT onoff);
INT btuirp(INT comno);
INT btuhit(INT comint);
INT btuxmn(INT chan,CHAR *datstg);
INT btuhdr(INT sapchn,INT bufsiz,VOID *buffer);
struct datstm FAR *btucdi(INT chan,struct datstm FAR *outsnk);
INT btupcc(INT chan,INT mode);
INT btuopl(INT chan);
VOID btuend(VOID);
VOID chiinp(INT chan,CHAR c);
VOID chiout(INT chan,CHAR c);
VOID chious(INT chan,CHAR *stg);
VOID chiinj(INT chan,INT s);
INT btuusp(INT chan,INT onoff);
USHORT btuTicker(VOID);
VOID locchn(INT chno);

#endif                             // __BRKTHU_H
