/***************************************************************************
 *                                                                         *
 *   BIGDIGIT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Font system for big digits using IBM Extended ASCII characters        *
 *                                                                         *
 *                                        - RNStein  7/30/94               *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

SHORT                              /*   returns next 'x' position          */
bigdigit(                          /* display a great big digit            */
const CHAR *font,                  /*   one of the digitNxN font stuctures */
SHORT dig,                         /*   digit 0-9 or '0' through '9'       */
SHORT x,                           /*   left of 3 columns, 0 to 78         */
SHORT y)                           /*   top of 3 rows, 0 to 22             */
{                                  /*   returns "next x" position          */
     CHAR n;
     SHORT sizch;

     if ((n=dig&0x0F) <= 9) {
          sizch=font[0]*font[1];
          setwin(curatr.scnstt,x,y,x+font[0]-1,y+font[1]-1,0);
          locate(x,y);
          printf(spr("%%0.%ds",sizch),font+3+sizch*n);
          rstloc();
          rstwin();
     }
     return(x+font[2]);
}
