/***************************************************************************
 *                                                                         *
 *   B2CCVT.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for converting a fixed-length VB-style  *
 *   string to a C-style string in place.  (The Basic string must either   *
 *   be NUL-terminated or be a minimum of bufsiz bytes in size.  If the    *
 *   unpadded string is exactly bufsiz bytes long, the last character is   *
 *   truncated.)                                                           *
 *                                                                         *
 *                                            - J. Alvrus   2/22/94        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns pointer to string          */
b2ccvt(                            /* cvt VB string to C format string     */
CHAR *str,                         /*   string to convert                  */
INT bufsiz)                        /*   size of string buffer              */
{
     CHAR *tmp;
     INT i,newlen,lnb,fnb=-1;

     if (bufsiz > 0) {
          for (i=0,tmp=str ; i < bufsiz && *tmp != '\0' ; i++,tmp++) {
               if (*tmp != ' ') {
                    lnb=i;
                    if (fnb < 0) {
                         fnb=i;
                    }
               }
          }
          newlen=(fnb < 0 ? 0 : lnb-fnb+1);
          if (fnb > 0) {
               movmem(str+fnb,str,newlen);
          }
          if (newlen == bufsiz) {
               newlen--;
          }
          setmem(str+newlen,bufsiz-newlen,'\0');
     }
     return(str);
}
