/***************************************************************************
 *                                                                         *
 *   ALCRSZ.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for re-allocating previously-alcmem'd   *
 *   data areas.                                                           *
 *                                                                         *
 *                                            - C. Robert  2/4/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

VOID *                             /*   newly reallocated block            */
alcrsz(                            /* resize previously allocated memory   */
VOID *mptr,                        /*   allocated block (NULL if none yet) */
UINT oldsize,                      /*   old size to carry over (or 0=none) */
UINT newsize)                      /*   requested memory size              */
{
     VOID *retval;
     UINT minsize;

     ASSERT(newsize != 0);
     retval=alcmem(newsize);
     if (mptr != NULL && (minsize=min(oldsize,newsize)) != 0) {
          movmem(mptr,retval,minsize);
          free(mptr);
     }
     return(retval);
}
