/***************************************************************************
 *                                                                         *
 *   WLMUTL.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging utility declarations.                             *
 *                                                                         *
 *                                            - J. Alvrus   1/14/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMUTL_H
#define __WLMUTL_H

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "worcomn.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define WLMAPID "WORMSG"           /* Worldlink module App-ID              */
#define WLMDESC "Worldlink Messaging" /* Worldlink module description      */
#define WLPOSTM "Worldlink Postmaster" /* Worldlink mail process name      */
#define INDIR   "in"               /* incoming mail subdirectory           */
#define OUTDIR  "out"              /* outgoing mail subdirectory           */
#define TMPDIR  "tmp"              /* temporary subdirectory               */
#define DFTATT  "FILENAME.EXT"     /* default attachment name              */
#define CHUNKSZ WBUFSZ             /* size of message chunks sent via cmd  */
#define FLSTNAM "wlforum.txt"      /* name of list of all WL forums        */

#define MAXFNAM (MAXADR-CSTRLEN("WF:")) /* max forum name length           */

                                   /* common client/server commands        */
#define CMD_RESET   0              /*   reset the connection               */
#define CMD_RSTRCV  1              /*   reset of connection acknowledgement*/
#define CMD_ERROR   2              /*   signal error in transmission       */
#define CMD_CANCEL  3              /*   abort transmission                 */
#define CMD_CANCRCV 4              /*   transmission abort acknowledgement */
#define CMD_ATT     5              /*   sending attachment                 */
#define CMD_ATTRCV  6              /*   acknowledge receipt of attachment  */
#define CMD_MSGDATA 7              /*   sending chunk of message           */
#define CMD_MSGDONE 8              /*   signal end of message data         */
#define CMD_MSGRCV  9              /*   acknowledge receipt of message     */
#define CMD_EOT     10             /*   signal end of transmission         */
#define CMD_SNDMAIL 11             /*   initiate/accept C->S mail xmit     */
#define CMD_GETFLST 12             /*   initiate/accept S->C forum list    */
#define CMD_GETINFO 13             /*   get general info on server config  */
#define CMD_GETFDET 14             /*   get forum details                  */
#define CMD_CRTFOR  15             /*   create forum                       */
#define CMD_GETFCFG 16             /*   get forum configuration            */
#define CMD_MODFCFG 17             /*   modify forum configuration         */
#define CMD_GETFACC 18             /*   get access of systems in forum     */
#define CMD_SETFACC 19             /*   set access of systems in forum     */
#define CMD_NONDFT  20             /*   get systems w/non-default access   */
#define CMD_DELFOR  21             /*   delete forum                       */

#define CMD_SIDBAS  20000          /* base value of side-specific commands */

                                   /* client-only commands                 */
#define CMD_NEWMAIL (CMD_SIDBAS+0) /*   new mail for system rcvd by hub    */
#define CMD_FORCHG  (CMD_SIDBAS+1) /*   forum info on hub has changed      */

                                   /* server-only commands                 */
#define CMD_GETEML  (CMD_SIDBAS+0) /*   initiate mail download             */
#define CMD_GETFOR  (CMD_SIDBAS+1) /*   initiate forum download            */

                                   /* protocol error codes                 */
#define ERR_NONE    0              /*   no error (aka success)             */
#define ERR_UNKNOWN 1              /*   unknown or unspecified error       */
#define ERR_SEQ     2              /*   command out of sequence            */
#define ERR_DATALEN 3              /*   too much/too little data sent      */
#define ERR_SPACE   4              /*   insufficient disk space/memory     */
#define ERR_NOTFND  5              /*   requested item not found           */
#define ERR_ACCESS  6              /*   no access to requested item        */
#define ERR_NOSYS   7              /*   no such client system              */
#define ERR_MAXCRT  8              /*   forum creation limit reached       */
#define ERR_EXISTS  9              /*   forum already exists (can't create)*/
#define ERR_BADNAME 10             /*   invalid name given                 */

#define CSTRLEN(stringConstant) (sizeof(stringConstant)-1)
#define NULSTR(s) ((s) == NULL || *(s) == '\0')

typedef                                                                      \
VOID                                                                         \
(*cmdFuncType)(                    /* command handling function            */\
UINT length,                       /*   command data length                */\
VOID *value);                      /*   command data                       */

typedef                                                                      \
INT                                /*   > 0 = target > test, etc.          */\
(*binSrchComp)(                    /* binary search util comparison func   */\
const VOID *target,                /*   target object                      */\
const VOID *array,                 /*   array object                       */\
ULONG index);                      /*   index of array element to test     */

extern HMCVFILE wlmb;              /* .MCV file handle                     */
extern GBOOL wlActive;             /* is Worldlink module active?          */
extern CHAR inpfx[PFXSIZ+1];       /* foreign internet mail prefix         */

VOID
initINPfx(                         /* initialize internet exporter prefix  */
INT msgnum);                       /*   MCV number to get from             */

GBOOL
wfval(                             /* WL forum addr validator for exporters*/
const CHAR *addr);                 /*   address to check                   */

GBOOL
wlmIsInetAddr(                     /* is this a valid SMTP address?        */
const CHAR *addr);                 /*   address to check                   */

GBOOL
wlmIsValForum(                     /* is this a valid WL forum name?       */
const CHAR *addr);                 /*   address to check                   */

GBOOL
wlmIsPostmaster(                   /* does this addr refer to Postmaster?  */
const CHAR *addr);                 /*   address to check                   */

GBOOL
wlmParseAddr(                      /* parse Worldlink address/User-ID      */
const CHAR *addr,                  /*   address to parse (no prefix)       */
struct wlmAddr *buf);              /*   buffer to place parsed results     */

GBOOL
isRegNo(                           /* is this string a registration number?*/
const CHAR *rno);                  /*   string to check                    */

CHAR *                             /*   returns pointer to destination     */
wlmSysID2Reg(                      /* get reg # from GME System-ID         */
LONG sysid,                        /*   GME System-ID to convert           */
CHAR *regno);                      /*   buffer for reg # (size >= 9)       */

CHAR *                             /*   returns pointer to address         */
subpfx(                            /* substitute an exporter prefix        */
CHAR *adr,                         /*   address to substitue on            */
const CHAR *pfx);                  /*   new prefix (including ':')         */

CHAR *                             /*   returns updated src, NULL if done  */
parseAccLine(                      /* extract a forum/system/access line   */
CHAR *src,                         /*   buffer to extract from             */
CHAR *sysName,                     /*   buf for sys name (must be WBOASIZ) */
INT *access);                      /*   buf for access or NULL to ignore   */

CHAR *                             /*   ptr to next item or NULL if no more*/
parseAccItem(                      /* parse an item out of an access line  */
CHAR **psrc,                       /*   ptr to ptr to source (updated)     */
CHAR sepchr);                      /*   item separator character           */

CHAR *                             /*   pointer to parsed-out word         */
parseWord(                         /* parse a word out of a string         */
CHAR **ppstr);                     /*   ptr to ptr to string (updated)     */

CHAR *                             /*   returns copy of ptr to dest        */
strmove(                           /* move string w/overlapping src/dest   */
CHAR *dst,                         /*   destination                        */
const CHAR *src);                  /*   source                             */

CHAR *                             /*   copy of pointer to destination     */
makePath(                          /* combine directory and file name      */
CHAR *dst,                         /*   destination buffer                 */
const CHAR *dir,                   /*   directory name                     */
const CHAR *file,                  /*   file name                          */
size_t dstSiz);                    /*   size of destination buffer         */

ULONG                              /*   index or numElems if not found     */
binSearch(                         /* generic binary search utility        */
const VOID *target,                /*   target object                      */
const VOID *array,                 /*   array object                       */
ULONG numElems,                    /*   number of elements in array object */
binSrchComp compFunc);             /*   comparison function                */

ULONG                              /*   index where element should be      */
binFindNear(                       /* generic binary find nearest utility  */
INT *lastComp,                     /*   result of last comparison          */
const VOID *target,                /*   target object                      */
const VOID *array,                 /*   array object                       */
ULONG numElems,                    /*   number of elements in array object */
binSrchComp compFunc);             /*   comparison function                */

INT
hexval(                            /* get hexadecimal value from digit     */
CHAR dig);                         /*   hexadecimal digit to convert       */

CHAR
hexdig(                            /* get hexadecimal value from digit     */
UINT val);                         /*   value to convert                   */

CHAR *                             /*   returns ptr to destination         */
getConfigStr(                      /* get string from configuration buffer */
const CHAR *sectName,              /*   section name                       */
const CHAR *itemName,              /*   item name                          */
const CHAR *dftVal,                /*   default value                      */
CHAR *dst,                         /*   destination buffer                 */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *src);                  /*   configuration buffer               */

GBOOL                              /*   returns TRUE if able to set        */
setConfigStr(                      /* set string in configuration buffer   */
const CHAR *sectName,              /*   section name                       */
const CHAR *itemName,              /*   item name                          */
const CHAR *value,                 /*   string to add                      */
CHAR *buf,                         /*   configuration buffer               */
size_t bufSiz);                    /*   size of configuration buffer       */

LONG                               /*   returns value of item              */
getConfigInt(                      /* get integer from configuration buffer*/
const CHAR *sectName,              /*   section name                       */
const CHAR *itemName,              /*   item name                          */
LONG dftVal,                       /*   default value                      */
const CHAR *src);                  /*   configuration buffer               */

GBOOL                              /*   returns TRUE if able to set        */
setConfigInt(                      /* set integer in configuration buffer  */
const CHAR *sectName,              /*   section name                       */
const CHAR *itemName,              /*   item name                          */
LONG value,                        /*   integer to add                     */
CHAR *buf,                         /*   configuration buffer               */
size_t bufSiz);                    /*   size of configuration buffer       */

GBOOL                              /*   returns TRUE if able to set        */
mergeConfig(                       /* merge two configuration buffers      */
CHAR *dst,                         /*   destination config buf (added to)  */
const CHAR *src,                   /*   source config (to be added)        */
size_t dstSiz);                    /*   size of destination buffer         */

CHAR *                             /*   ptr to first char on line or NULL  */
nextLine(                          /* find next line in a string           */
const CHAR *str,                   /*   string to search                   */
const CHAR *eol);                  /*   end-of-line marker string          */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMUTL_H