/***************************************************************************
 *                                                                         *
 *   WLMSTORU.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging side-independent storage utilities.               *
 *                                                                         *
 *                                            - J. Alvrus   1/14/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMSTORU_H
#define __WLMSTORU_H

#include "gcomm.h"
#include "wlmutl.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define STORID   "WLM "            /* message store ID string              */
#define STORVER  "100"             /* message store ID string              */
#define CTRLZ    '\x1A'            /* ^Z character                         */
#define WLMNOIDX ((ULONG)-1)       /* initial high index value             */
#define CVTWLM   CVTPACKED         /* cvt flags for msg section headers    */

                                   /* storage utility error codes          */
#define STER_NONE   0              /*   no error                           */
#define STER_EOF    1              /*   end of file reached                */
#define STER_MEM    2              /*   insufficient memory                */
#define STER_IO     3              /*   I/O error                          */
#define STER_BADFIL 4              /*   store file corrupted               */
#define STER_BADPOS 5              /*   invalid file position              */

struct storFileHdr {               /* store file header structure          */
     CHAR id[CSTRLEN(STORID)];     /*   file ID                            */
     CHAR ver[CSTRLEN(STORVER)];   /*   file version                       */
     CHAR ctrlz;                   /*   ^Z (for TYPE'ers)                  */
     ULONG loidx;                  /*   index of first message in file     */
     ULONG hiidx;                  /*   index of last message in file      */
};

#define WLMHDRSIG "\xCA\xC1\xB6\xB5" /* message header signature           */

struct storMsgHdr {                /* store file message header            */
     CHAR sig[CSTRLEN(WLMHDRSIG)]; /*   signature (CA C1 B6 B5)            */
     ULONG flg;                    /*   message header flags               */
     ULONG idx;                    /*   message index                      */
     ULONG ndx;                    /*   inverse index (~idx)               */
     ULONG len;                    /*   length of message contents         */
};

                                   /* message header flag masks            */
#define WLMF_DEL    1              /*   message has been deleted           */

typedef
struct storFile {                  /* store file management structure      */
     struct storFileHdr filhdr;    /*   file header                        */
     struct storMsgHdr msghdr;     /*   current message header             */
     ULONG curpos;                 /*   current input position             */
     CHAR filnam[GCMAXPTH];        /*   file name                          */
} STORFILE;                        /* typedef for FILE-like use            */

extern CHAR *mailRoot;             /* root directory for mail processing   */
extern CHAR *outDir;               /* outbound files directory             */
extern CHAR *inDir;                /* inbound files directory              */
extern CHAR *tmpDir;               /* temporary files directory            */

STORFILE *                         /*   returns pointer to created file    */
storCreate(                        /* create a store file                  */
const CHAR *fileName,              /*   file to create                     */
ULONG startIdx);                   /*   initial value for message index    */

STORFILE *                         /*   returns pointer to opened file     */
storOpen(                          /* open a store file                    */
const CHAR *fileName);             /*   file to open                       */

VOID
storClose(                         /* close a store file                   */
STORFILE *sfp);                    /*   store file to close                */

GBOOL
storAddMsg(                        /* add a message to a store file        */
STORFILE *sfp,                     /*   store file to add to               */
const VOID *buf,                   /*   buffer containing contents         */
size_t len);                       /*   length of contents                 */

size_t                             /*   returns # bytes read or 0 if EOF   */
storNextMsg(                       /* read next message from store         */
STORFILE *sfp,                     /*   store file to read from            */
VOID *dst,                         /*   buffer to read into                */
size_t len);                       /*   length of buffer                   */

size_t                             /*   returns # bytes read or 0 if error */
storReadMsg(                       /* read current message from store      */
STORFILE *sfp,                     /*   store file to read from            */
VOID *dst,                         /*   buffer to read into                */
size_t len);                       /*   length of buffer                   */

GBOOL                              /*   returns TRUE if successful         */
storDelMsg(                        /* mark current message deleted         */
STORFILE *sfp);                    /*   store file in use                  */

INT
storLastErr(VOID);                 /* get last error code                  */

ULONG
storLastIdx(VOID);                 /* get index of last msg read/written   */

const CHAR *                       /*   returns pointer to temp buffer     */
makeInFile(                        /* make a file name in a WL inbound dir */
const CHAR *fileName);             /*   file name to use                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMSTORU_H