/***************************************************************************
 *                                                                         *
 *   WLMSTORC.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client side-specific storage utilities.           *
 *                                                                         *
 *                                            - J. Alvrus   1/22/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMSTORC_H
#define __WLMSTORC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern GBOOL wlStorActive;         /* have server storage utils been init? */
extern CHAR *outStor;              /* file for outbound messages           */

#define makeOutFile(name) makeWLFile(OUTDIR,(name))
#define makeOutAtt(idx)   makeOutFile(makeAttName(idx))
#define makeInAtt(idx)    makeInFile(makeAttName(idx))

GBOOL
initCliStor(VOID);                 /* initialize client storage utility    */

VOID
closeCliStor(VOID);                /* shut down client storage utility     */

const CHAR *                       /*   returns pointer to temp buffer     */
makeWLFile(                        /* make a file name in a Worldlink dir  */
const CHAR *dirName,               /*   subdir under Worldlink root        */
const CHAR *fileName);             /*   file name to use                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMSTORC_H