/***************************************************************************
 *                                                                         *
 *   WLMSTORC.C                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client side-specific storage utilities.           *
 *                                                                         *
 *                                            - J. Alvrus   1/22/97        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gme.h"
#include "wormsg.h"
#include "wlmutl.h"
#include "wlmmsgu.h"
#include "wlmstoru.h"
#include "wlmstorc.h"

#define FILREV "$Revision: 3 $"

GBOOL wlStorActive=FALSE;          /* have store utils been initialized?   */
CHAR *outStor;                     /* file for outbound messages           */

GBOOL
initCliStor(VOID)                  /* initialize client storage utility    */
{
     CHAR tmpPth[GCMAXPTH];

     mailRoot=stgopt(WLROOT);
     inDir=strdup(makePath(tmpPth,mailRoot,INDIR,GCMAXPTH));
     outDir=strdup(makePath(tmpPth,mailRoot,OUTDIR,GCMAXPTH));
     tmpDir=strdup(makePath(tmpPth,mailRoot,TMPDIR,GCMAXPTH));
     if (!fmdir(mailRoot) || !fmdir(inDir)
      || !fmdir(outDir) || !fmdir(tmpDir)) {
          shocst("WORLDLINK MAIL INACTIVE",
                 "Bad processing directory: %s",mailRoot);
          return(FALSE);
     }
     outStor=strdup(makeOutFile(STORNAM));
     wlStorActive=TRUE;
     return(TRUE);
}

VOID
closeCliStor(VOID)                 /* shut down client storage utility     */
{
     if (wlStorActive) {
          free(inDir);
          free(outDir);
          free(tmpDir);
          free(outStor);
     }
     wlStorActive=FALSE;
}

const CHAR *                       /*   returns pointer to temp buffer     */
makeInFile(                        /* make a file name in a WL inbound dir */
const CHAR *fileName)              /*   file name to use                   */
{
     return(makeWLFile(INDIR,fileName));
}

const CHAR *                       /*   returns pointer to temp buffer     */
makeWLFile(                        /* make a file name in a Worldlink dir  */
const CHAR *dirName,               /*   subdir under Worldlink root        */
const CHAR *fileName)              /*   file name to use                   */
{
     static CHAR retBuf[GCMAXPTH];

     makePath(retBuf,mailRoot,dirName,GCMAXPTH);
     return(makePath(retBuf,NULL,fileName,GCMAXPTH));
}
