/***************************************************************************
 *                                                                         *
 *   WLMSGU.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging transit message management utilities.             *
 *                                                                         *
 *                                            - J. Alvrus   1/14/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMSGU_H
#define __WLMSGU_H

#include "gcomm.h"
#include "gme.h"
#include "wlmstoru.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define STORNAM "message.wlm"      /* standard in/outbound store file name */
#define WLMAXHDR  4096             /* size of buffer for headers           */
#define WLMAXTXT  16384            /* largest text size supported by WL    */
#define MSGBUFSIZ (2*WLMAXTXT+WLMAXHDR+3*sizeof(struct storMsgHdr))
#define WLMDATEFMT "%04d%02d%02d %02d%02d%02d" /* date format string       */
#define WLMDATESIZ sizeof("19650203 093700") /* date string buffer size    */

                                   /* Worldlink transit message headers    */
#define WLH_TO       "To"          /*   destination address                */
#define WLH_FORUM    "Forum"       /*   forum/newsgroup name               */
#define WLH_THRID    "Thread-ID"   /*   thread ID (forum only)             */
#define WLH_GLOBID   "Global-ID"   /*   global ID (forum only)             */
#define WLH_FROM     "From"        /*   sender's address                   */
#define WLH_TOPIC    "Topic"       /*   message topic                      */
#define WLH_HISTORY  "History"     /*   message history                    */
#define WLH_ATTNAME  "Attachment-Name" /* attachment name (if any)         */
#define WLH_DATE     "Date"        /*   creation date                      */
#define WLH_RPLTO    "Reply-To"    /*   reply-to ID (forum only)           */
#define WLH_PRIORITY "Priority"    /*   priority flag                      */
#define WLH_RETRCP   "Return-Receipt" /* return receipt flag               */
#define WLH_HOPS     "Hops"        /*   number of hops                     */
#define WLH_ERRMSG   "Error-Message" /* error message, don't autoforward   */
#define WLH_CONTROL  "Control"     /*   control message                    */
#define WLH_RCVFROM  "Received-From" /* received-from history              */

                                   /* standard control message types       */
#define CMSG_CANCEL  "cancel"      /*   network delete of forum message    */
#define CMSG_MODIFY  "modify"      /*   network modification of forum msg  */

                                   /* transit message section names        */
#define HDRSECT "head"             /*   message header                     */
#define TXTSECT "body"             /*   body text                          */
#define APPSECT "appinfo"          /*   app-defined info                   */

#define WLMSECTLEN  8              /* message section name size (no NULL)  */
#define WLMSHDRSIZ  (WLMSECTLEN+sizeof(ULONG)) /* packed length of sect hdr*/

struct wlmSectHdr {                /* transit message section header       */
     CHAR name[WLMSECTLEN];        /*   section name (space-padded)        */
     ULONG len;                    /*   length of section contents         */
};

extern struct flddef wlmSectHdrFDA[]; /* FDA for message section headers  */

extern GBOOL wlMsgActive;          /* have message utils been initialized? */
extern VOID *wlMsgBuf;             /* temp buf for reading/writing msgs    */
extern CHAR *wlHdrBuf;             /* temp WLM header buffer               */

GBOOL
initMsgUtil(VOID);                 /* initialize transit message utility   */

VOID
closeMsgUtil(VOID);                /* shut down transit message utility    */

GBOOL                              /*   returns TRUE if successful         */
addMsg2Stor(                       /* generic add message to store         */
const CHAR *storFile,              /*   path+file name of store file to use*/
ULONG idxInit,                     /*   initial idx if store doesn't exist */
const VOID *msgBuf,                /*   buffer containing contents to store*/
size_t bufLen,                     /*   length of contents                 */
const CHAR *attDir,                /*   final resting place for attachment */
const CHAR *attFile);              /*   current attachment path+file name  */
                                   /*   (NULL if none)                     */

size_t                             /*   returns # of bytes put in dst      */
makeTransitMsg(                    /* form transit-format message          */
VOID *dstBuf,                      /*   destination buffer                 */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *forum,                 /*   forum name or NULL if email        */
const CHAR *to,                    /*   to address                         */
const CHAR *from,                  /*   from address in exporter format    */
const struct message *pmsg,        /*   GME message header                 */
const CHAR *text,                  /*   message body                       */
const CHAR *appInfo);              /*   application-defined info (if any)  */

GBOOL                              /*   returns FALSE if bad forum         */
xltTransitMsg(                     /* translate transit msg to GME format  */
VOID *srcBuf,                      /*   buffer containing transit msg      */
size_t srcLen,                     /*   length of transit message          */
struct message *pmsg,              /*   message header to fill in          */
CHAR *text,                        /*   buffer for text (must be TXTLEN)   */
CHAR *appinf,                      /*   buf for app info (must be TXTLEN)  */
GBOOL attFlag);                    /*   is there an attachment?            */

size_t                             /*   returns # of bytes used in buffer  */
wlmSetSect(                        /* set a section in a message buffer    */
VOID *buf,                         /*   buffer to add to                   */
size_t bufUsed,                    /*   # bytes currently used in buffer   */
size_t bufSiz,                     /*   total size of buffer               */
const CHAR *sectName,              /*   name of section                    */
const VOID *sect,                  /*   buffer containing section content  */
size_t sectLen);                   /*   length of contents                 */

size_t                             /*   returns # of bytes used in buffer  */
wlmSetSectStr(                     /* put a string section in a msg buffer */
VOID *buf,                         /*   buffer to add to                   */
size_t bufUsed,                    /*   # bytes currently used in buffer   */
size_t bufSiz,                     /*   total size of buffer               */
const CHAR *sectName,              /*   name of section                    */
const CHAR *sect);                 /*   section content string             */

size_t                             /*   returns # bytes put into dest      */
wlmGetSect(                        /* get a section from a message buffer  */
VOID *dst,                         /*   buffer to receive section          */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *sectName,              /*   name of section                    */
const VOID *src,                   /*   buffer containing message          */
size_t srcLen);                    /*   length of message                  */

CHAR *                             /*   returns pointer to destination     */
wlmGetSectStr(                     /* get a string section from msg buffer */
CHAR *dst,                         /*   buffer to receive section          */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *sectName,              /*   name of section                    */
const VOID *src,                   /*   buffer containing message          */
size_t srcLen);                    /*   length of message                  */

const CHAR *                       /*   returns pointer to temp buffer     */
wlmHeader(                         /* form header for WLM message          */
const CHAR *forum,                 /*   forum name or NULL if email        */
const CHAR *to,                    /*   to address                         */
const CHAR *from,                  /*   from address in exporter format    */
const struct message *pmsg);       /*   GME message header                 */

CHAR *                             /*   returns pointer to destination     */
getWLHeader(                       /* get a WLM header from a buffer       */
CHAR *dst,                         /*   destination buffer                 */
size_t bufSiz,                     /*   size of destination buffer         */
const CHAR *kwd,                   /*   header keyword to find             */
const CHAR *dftval,                /*   default value if keyword not found */
const CHAR *src);                  /*   source buffer                      */

CHAR *                             /*   returns pointer to destination     */
setWLHeader(                       /* add WLM header to buffer             */
CHAR *dst,                         /*   destination buffer                 */
const CHAR *kwd,                   /*   header keyword                     */
const CHAR *val,                   /*   header value                       */
size_t bufSiz);                    /*   size of destination buffer         */

const CHAR *                       /*   returns pointer to temp buffer     */
wlmDateStr(                        /* generate WLM date string             */
USHORT date,                       /*   DOS date                           */
USHORT time);                      /*   DOS time                           */

GBOOL                              /*   returns TRUE if successful         */
xltDateStr(                        /* translate WLM date string            */
const CHAR *dateStr,               /*   WLM-format date string             */
USHORT *date,                      /*   buffer to receive DOS date         */
USHORT *time);                     /*   buffer to receive DOS time         */

const CHAR *                       /*   returns pointer to temp buffer     */
wlmGlobIDStr(                      /* generate GME global ID string        */
const struct globid *gid);         /*   global ID to convert               */

VOID
getHdrGlobID(                      /* read a global ID from a msg header   */
struct globid *gid,                /*   buffer to take global ID           */
const CHAR *hdr,                   /*   name of header to read             */
const CHAR *src);                  /*   buffer containing headers          */

GBOOL                              /*   returns TRUE if successful         */
xltGlobIDStr(                      /* translate global ID string to struct */
const CHAR *idStr,                 /*   WL string format global ID         */
struct globid *gid);               /*   buffer to fill in                  */

const CHAR *                       /*   returns pointer to temp buffer     */
makeAttName(                       /* form attachment name                 */
ULONG msgIdx);                     /*   based on message index             */

CHAR *                             /*   returns pointer to destination     */
formErrorMsg(                      /* form top of error message text       */
CHAR *dst,                         /*   destination buffer (TXTLEN long)   */
INT errmsg,                        /*   MCV number of message framework    */
INT reason,                        /*   MCV # of reason for error message  */
const CHAR *dateStr,               /*   WLM-format date string             */
const CHAR *recip,                 /*   intended recipient                 */
const CHAR *topic);                /*   topic of message                   */
                                   /*   (setmbk must be done by caller)    */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMSGU_H