/***************************************************************************
 *                                                                         *
 *   WLMMODC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Server exporter utilities.                        *
 *                                                                         *
 *                                            - J. Alvrus   1/21/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMMODC_H
#define __WLMMODC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define NOREQ (-1)                 /* ID indicating no current request     */

                                   /* extended errors used by client       */
#define ERR_DISC    10000          /*   system disconnected from hub       */
#define ERR_RESET   10001          /*   connection to hub was reset        */
#define ERR_CANCEL  10002          /*   operation was cancelled            */

typedef
VOID
(*mgrRespFunc)(                    /* got response to mgr op function type */
INT reqid,                         /*   request ID getting response        */
const CHAR *value);                /*   info returned by hub               */

typedef
VOID
(*mgrAbortFunc)(                   /* management op aborted function type  */
INT reqid,                         /*   request ID getting response        */
INT reason);                       /*   reason for abort                   */

extern GBOOL wlModActive;          /* has Worldlink module been init?      */

GBOOL
initWLModule(VOID);                /* initialize Worldlink module          */

VOID
closeWLModule(VOID);               /* shut down Worldlink module           */

VOID
resetSys(VOID);                    /* reset mail system                    */

VOID
sndStart(VOID);                    /* start sending outgoing mail (if any) */

VOID
sndStop(VOID);                     /* cancel sending outgoing mail (if any)*/

GBOOL
rcvStart(VOID);                    /* check for new mail for us            */

VOID
rcvStop(VOID);                     /* cancel receiving of mail (if any)    */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrGetDetails(                     /* get forum details from hub           */
const CHAR *name,                  /*   WL forum name                      */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrGetConfig(                      /* get forum configuration from hub     */
const CHAR *name,                  /*   WL forum name                      */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrCreateFor(                      /* create a forum on the hub            */
const CHAR *cfg,                   /*   configuration info to create with  */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrModifyFor(                      /* modify a forum on the hub            */
const CHAR *cfg,                   /*   new configuration info             */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrDeleteFor(                      /* delete a forum on the hub            */
const CHAR *name,                  /*   WL forum name                      */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrGetAccess(                      /* get forum access from hub            */
const CHAR *list,                  /*   WL forum name + list of systems    */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrGetNonDft(                      /* get non-default forum access from hub*/
const CHAR *name,                  /*   WL forum name                      */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

GBOOL                              /*   returns TRUE if request forwarded  */
mgrSetAccess(                      /* set forum access on hub              */
const CHAR *list,                  /*   WL forum + list of systems/access  */
INT reqid,                         /*   request ID to respond to           */
mgrRespFunc respFunc,              /*   func to call with success response */
mgrAbortFunc abortFunc);           /*   func to call with error response   */

VOID
mgrCancel(                         /* notify WL module of operation cancel */
INT reqid);                        /*   request ID being cancelled         */

VOID
mgrStop(VOID);                     /* cancel any activity of management sys*/

VOID
genStop(VOID);                     /* cancel any activity of general system*/

const CHAR *                       /*   pointer to internal buffer         */
statSend(VOID);                    /* get sender status                    */

const CHAR *                       /*   pointer to internal buffer         */
statRecv(VOID);                    /* get receiver status                  */

const CHAR *                       /*   pointer to internal buffer         */
statMgr(VOID);                     /* get management system status         */

const CHAR *                       /*   pointer to internal buffer         */
statSys(VOID);                     /* get general system status            */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMMODC_H