/***************************************************************************
 *                                                                         *
 *   WLMINSU.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging side-independent incoming message storage         *
 *   utilities.                                                            *
 *                                                                         *
 *                                            - J. Alvrus   1/14/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMINSU_H
#define __WLMINSU_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern GBOOL wlISUActive;          /* has incoming store been initialized  */

extern CHAR *inStor[2];            /* incoming message store file(s)       */
extern INT rcvStorNum;             /* index of store file to receive into  */
extern INT impStorNum;             /* index of store file to import from   */
extern ULONG rcvHighIdx;           /* high message index of incoming msgs  */

GBOOL
initInStor(VOID);                  /* initialize incoming store files      */

VOID
closeInStor(VOID);                 /* shut down incoming msg store utility */

GBOOL                              /*   returns TRUE if successful         */
addMsg2In(                         /* add msg to the incoming store        */
const VOID *msgBuf,                /*   buffer containing transit-fmt msg  */
size_t bufLen,                     /*   length of contents                 */
const CHAR *attFile);              /*   attached file (NULL if none)       */

VOID
swapInStors(VOID);                 /* swap indices of incoming store files */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMINSU_H