/***************************************************************************
 *                                                                         *
 *   WLMINSU.C                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Incoming Messaging Storage Utilities.                       *
 *                                                                         *
 *                                            - J. Alvrus   2/13/97        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "wlmstoru.h"
#include "wlmmsgu.h"
#include "wlminsu.h"

#define FILREV "$Revision: 1.2 $"

GBOOL wlISUActive=FALSE;           /* has incoming store been initialized  */

CHAR *inStor[2];                   /* incoming message store file(s)       */
INT rcvStorNum;                    /* index of store file to receive into  */
INT impStorNum;                    /* index of store file to import from   */
ULONG rcvHighIdx;                  /* high message index of incoming msgs  */

GBOOL
initInStor(VOID)                   /* initialize incoming store files      */
{
     INT i;
     STORFILE *sfp;
     ULONG hiidx[2];

     inStor[0]=strdup(makeInFile("message0.wlm"));
     inStor[1]=strdup(makeInFile("message1.wlm"));
     rcvStorNum=0;
     impStorNum=1;
     for (i=0 ; i < 2 ; ++i) {
          hiidx[i]=0;
          if (isfile(inStor[i])) {
               if ((sfp=storOpen(inStor[i])) == NULL) {
                    catastro("UNABLE TO READ INCOMING MAIL FILE:\n%s",inStor[i]);
               }
               hiidx[i]=sfp->filhdr.hiidx;
               storClose(sfp);
          }
     }
     if (hiidx[rcvStorNum] < hiidx[impStorNum]) {
          swapInStors();
     }
     rcvHighIdx=hiidx[rcvStorNum];
     wlISUActive=TRUE;
     return(TRUE);
}

VOID
closeInStor(VOID)                  /* shut down incoming msg store utility */
{
     if (wlISUActive) {
          free(inStor[0]);
          free(inStor[1]);
     }
     wlISUActive=FALSE;
}

GBOOL                              /*   returns TRUE if successful         */
addMsg2In(                         /* add msg to the incoming store        */
const VOID *msgBuf,                /*   buffer containing transit-fmt msg  */
size_t bufLen,                     /*   length of contents                 */
const CHAR *attFile)               /*   attached file (NULL if none)       */
{
     GBOOL flg;

     flg=addMsg2Stor(inStor[rcvStorNum],rcvHighIdx+1,msgBuf,bufLen,inDir,
                     attFile);
     rcvHighIdx=storLastIdx();
     return(flg);
}

VOID
swapInStors(VOID)                  /* swap indices of incoming store files */
{
     impStorNum=rcvStorNum;
     rcvStorNum^=1;
}
