/***************************************************************************
 *                                                                         *
 *   WLMIMPC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client importer utilities.                        *
 *                                                                         *
 *                                            - J. Alvrus   1/27/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMIMPC_H
#define __WLMIMPC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern GBOOL wlImpActive;          /* have importer utils been initialized?*/
extern GBOOL wlImpBkgnd;           /* use background importer?             */
extern GBOOL impInProg;            /* Worldlink importing a message        */
extern INT impCurHops;             /* "Hops=" value of current imported msg*/
extern CHAR *impOrgDate;           /* original date of imported message    */
extern CHAR inpfx[PFXSIZ+1];       /* foreign internet mail prefix         */
extern GBOOL impDeleting;          /* Worldlink deleting a message         */
extern GBOOL impModifying;         /* Worldlink modifying a message        */

GBOOL                              /*   returns FALSE if error             */
initImp(VOID);                     /* initialize importer utilities        */

VOID
closeImp(VOID);                    /* shut down importer utilities         */

VOID
impStart(VOID);                    /* start background importer            */

VOID
impStop(VOID);                     /* stop background importer             */

GBOOL                              /*   returns FALSE if error preparing   */
impPrepMsg(                        /* prepare a message for import         */
VOID *msgBuf,                      /*   buffer containing transit message  */
size_t msgLen,                     /*   length of buffer contents          */
const CHAR *attFile);              /*   attachment path+file name (if any) */

GBOOL                              /*   returns FALSE when done            */
impPump(VOID);                     /* pump message importer                */

VOID
cancelImp(VOID);                   /* cancel any ongoing importer activity */

const CHAR *                       /*   pointer to internal buffer         */
statImp(VOID);                     /* get importer status                  */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMIMPC_H