/***************************************************************************
 *                                                                         *
 *   WLMFORU.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging forum crossreference utilities.                   *
 *                                                                         *
 *                                            - J. Alvrus   1/28/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMFORU_H
#define __WLMFORU_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define wlForumExists(nam) (getWLForumID(nam) != EMLID)

extern struct forxref {            /* local to WL forum crossreference     */
     USHORT forum;                 /*   local forum ID                     */
     CHAR name[MAXFNAM];           /*   WL forum name                      */
} **xrfList;                       /* pointer to list of xrefs             */

extern INT xrfInUse;               /* # xref array elements in use         */

extern GBOOL wlXrefActive;         /* has forum xref been initialized?     */

VOID
initForXref(VOID);                 /* initialize forum crossref utility    */

VOID
closeForXref(VOID);                /* shut down forum crossreference       */

INT                                /*   (returns NOIDX if not found)       */
xrfForumIdx(                       /* get index of forum in xref list      */
const CHAR *forName);              /*   WL forum name                      */

/* side-dependent utilities */

USHORT                             /*   forum ID or EMLID if not found     */
getWLForumID(                      /* get forum ID associated w/WL forum   */
const CHAR *forName);              /*   Worldlink forum name               */

GBOOL
xrfUseEcho(                        /* add this echo to crossreference?     */
const CHAR *echo);                 /*   echo address to check              */

VOID
xrfChanged(VOID);                  /* notification of WL forum change      */

VOID
xrfDeleting(                       /* notification of WL forum deleted     */
USHORT forum,                      /*   GME forum ID deleted (already gone)*/
const CHAR *name);                 /*   WL name of deleted forum           */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMFORU_H