/***************************************************************************
 *                                                                         *
 *   WLMEXPC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Server exporter utilities.                        *
 *                                                                         *
 *                                            - J. Alvrus   1/21/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMEXPC_H
#define __WLMEXPC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern GBOOL wlExpActive;          /* have exporter utils been initialized?*/
extern GBOOL wlUseEmail;           /* use WL for email?                    */
extern CHAR wlpfx[PFXSIZ+1];       /* WL email exporter prefix             */
extern CHAR wfpfx[PFXSIZ+1];       /* WL forum exporter prefix             */

GBOOL                              /*   returns FALSE if error             */
initExp(VOID);                     /* initialize exporter utilities        */

VOID
closeExp(VOID);                    /* shut down exporter utilities         */

const CHAR *                       /*   returns temp buffer                */
fixExpAddr(                        /* make address into export format      */
const CHAR *orgAddr);              /*   original address                   */

GBOOL
wlmIsNativeAddr(                   /* is this a WL or SMTP address         */
const CHAR *addr);                 /*   address to examine                 */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMEXPC_H