/***************************************************************************
 *                                                                         *
 *   WLMEXPC.C                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client exporter functions.                        *
 *                                                                         *
 *                                            - J. Alvrus   1/22/97        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gme.h"
#include "smtpexp.h"
#include "worldlnk.h"
#include "wormsg.h"
#include "wlmutl.h"
#include "wlmstorc.h"
#include "wlmmsgu.h"
#include "wlmcfgc.h"
#include "wlmimpc.h"
#include "wlmexpc.h"
#include "wlmmodc.h"

#define FILREV "$Revision: 6 $"
const CHAR *wlhlp(VOID);
GBOOL wlval(const CHAR *addr);
const CHAR *wlasp(const CHAR *to,const struct message *msg);
INT wlsnd(const CHAR *to,const struct message *msg,const CHAR *text,
          const CHAR *filatt);
const CHAR *wfhlp(VOID);
INT wfsnd(const CHAR *forum,const struct message *msg,const CHAR *text,
          const CHAR *filatt);

struct exporter wlexp={            /* Worldlink email exporter             */
     "",                           /*   address prefix for this exporter   */
     "",                           /*   name of exporter                   */
     "",                           /*   description of exporter            */
     "",                           /*   example address to this exporter   */
     "",                           /*   key required to use this exporter  */
     0,                            /*   per-message surcharge              */
     "",                           /*   key required for file attachments  */
     0,                            /*   attachment surcharge               */
     0,                            /*   attachment per-kbyte surcharge     */
     "",                           /*   key required to request return recp*/
     0,                            /*   return receipt request surcharge   */
     "",                           /*   key required to send priority msg  */
     0,                            /*   priority surcharge                 */
     (EXPATT|EXPRRR|EXPPRI|EXPFMT),/*   supported features flags           */
     wlhlp,                        /*   get help message for this exporter */
     wlval,                        /*   is this a valid address vector     */
     wlasp,                        /*   path+file name for attachments     */
     wlsnd                         /*   send message vector                */
};

struct exporter wfexp={            /* Worldlink email exporter             */
     "",                           /*   address prefix for this exporter   */
     "",                           /*   name of exporter                   */
     "",                           /*   description of exporter            */
     "",                           /*   example address to this exporter   */
     "",                           /*   key required to use this exporter  */
     0,                            /*   per-message surcharge              */
     "",                           /*   key required for file attachments  */
     0,                            /*   attachment surcharge               */
     0,                            /*   attachment per-kbyte surcharge     */
     "",                           /*   key required to request return recp*/
     0,                            /*   return receipt request surcharge   */
     "",                           /*   key required to send priority msg  */
     0,                            /*   priority surcharge                 */
     (EXPATT|EXPFMT),              /*   supported features flags           */
     wfhlp,                        /*   get help message for this exporter */
     wfval,                        /*   is this a valid address vector     */
     wlasp,                        /*   path+file name for attachments     */
     wfsnd                         /*   send message vector                */
};

GBOOL wlExpActive=FALSE;           /* have exporter utils been initialized?*/
GBOOL wlUseEmail;                  /* use WL for email?                    */
CHAR wlpfx[PFXSIZ+1]="";           /* WL email exporter prefix             */
CHAR wfpfx[PFXSIZ+1]="";           /* WL forum exporter prefix             */

struct fordef fdef;                /* forum definition buffer for GME hooks*/

VOID expCancelMsg(INT deltype,const struct message *msg,const CHAR *text);
VOID expModifyMsg(INT updtype,const struct message *msg,const CHAR *text);
CHAR *tvWLAddr(VOID);
CHAR *tvEmlPrefix(VOID);
CHAR *tvForPrefix(VOID);
const CHAR *expHelp(INT msgNum);
INT expMsg(const CHAR *forum,const CHAR *to,const struct message *msg,
           const CHAR *text,const CHAR *filatt);

GBOOL                              /*   returns FALSE if error             */
initExp(VOID)                      /* initialize exporter utilities        */
{
     wlUseEmail=ynopt(USEWL);
     if (wlUseEmail) {
          stlcpy(wlexp.prefix,rawmsg(WLPFX),PFXSIZ);
          stlcpy(wlexp.name,rawmsg(WLNAME),EXPNSZ);
          stlcpy(wlexp.desc,rawmsg(WLDESC),EXPDSZ);
          stlcpy(wlexp.exmp,rawmsg(WLEXMP),MAXADR);
          stlcpy(wlexp.wrtkey,rawmsg(WLKEY),KEYSIZ);
          wlexp.wrtchg=numopt(WLCHG,-32767,32767);
          stlcpy(wlexp.attkey,rawmsg(WLATKY),KEYSIZ);
          wlexp.attchg=numopt(WLATCH,-32767,32767);
          wlexp.apkchg=numopt(WLPKCH,-32767,32767);
          stlcpy(wlexp.rrrkey,rawmsg(WLRRKY),KEYSIZ);
          wlexp.rrrchg=numopt(WLRRCH,-32767,32767);
          stlcpy(wlexp.prikey,rawmsg(WLPRKY),KEYSIZ);
          wlexp.prichg=numopt(WLPRCH,-32767,32767);
          register_exp(&wlexp);
          stlcat(stlcpy(wlpfx,wlexp.prefix,PFXSIZ),":",PFXSIZ+1);
     }
     stlcpy(wfexp.prefix,rawmsg(WFPFX),PFXSIZ);
     stlcpy(wfexp.name,rawmsg(WFNAME),EXPNSZ);
     stlcpy(wfexp.desc,rawmsg(WFDESC),EXPDSZ);
     stlcpy(wfexp.exmp,rawmsg(WFEXMP),MAXADR);
     stlcpy(wfexp.wrtkey,rawmsg(WFKEY),KEYSIZ);
     wfexp.wrtchg=numopt(WFCHG,-32767,32767);
     stlcpy(wfexp.attkey,rawmsg(WFATKY),KEYSIZ);
     wfexp.attchg=numopt(WFATCH,-32767,32767);
     wfexp.apkchg=numopt(WFPKCH,-32767,32767);
     register_exp(&wfexp);
     stlcat(stlcpy(wfpfx,wfexp.prefix,PFXSIZ),":",PFXSIZ+1);
     hook_gme(GMEHOOK_NOT_DELMSG,(voidfunc)expCancelMsg);
     hook_gme(GMEHOOK_NOT_UPDMSG,(voidfunc)expModifyMsg);
     register_textvar("WLM_EMAIL_ADDR",tvWLAddr);
     register_textvar("WLM_EMAIL_PFX",tvEmlPrefix);
     register_textvar("WLM_FORUM_PFX",tvForPrefix);
     wlExpActive=TRUE;
     return(TRUE);
}

VOID
closeExp(VOID)                     /* shut down exporter utilities         */
{
     wlExpActive=FALSE;
}

VOID
expCancelMsg(                      /* message has been deleted hook        */
INT deltype,                       /*   how new message was deleted code   */
const struct message *msg,         /*   new message header                 */
const CHAR *text)                  /*   new message text                   */
{
     INT i;
     size_t len;
     adr_t *echo;
     CHAR tmpbuf[sizeof(CMSG_CANCEL " 1234567890 1234567890")];

     (VOID)text;
     if (wlExpActive && !impDeleting && deltype == DELMSG_NORM
      && msg->forum != EMLID && sameas(msg->from,gmexinf())) {
          getdefb(msg->forum,&fdef);
          echo=(adr_t *)fdef.echoes;
          for (i=0 ; i < fdef.necho ; ++i) {
               if (sameto(wfpfx,echo[i]) && getNetCanOut(skppfx(echo[i]))) {
                    stlcpy(tmpbuf,CMSG_CANCEL " ",sizeof(tmpbuf));
                    stlcat(tmpbuf,wlmGlobIDStr(&msg->gmid),sizeof(tmpbuf));
                    *wlHdrBuf='\0';
                    setWLHeader(wlHdrBuf,WLH_CONTROL,tmpbuf,WLMAXHDR);
                    setWLHeader(wlHdrBuf,WLH_FORUM,skppfx(echo[i]),WLMAXHDR);
                    setWLHeader(wlHdrBuf,WLH_FROM,fixExpAddr(msg->from),WLMAXHDR);
                    len=wlmSetSectStr(wlMsgBuf,0,MSGBUFSIZ,HDRSECT,wlHdrBuf);
                    addMsg2Stor(outStor,0L,wlMsgBuf,len,outDir,NULL);
                    rtkick(1,sndStart);
                    return;
               }
          }
     }
}

VOID
expModifyMsg(                      /* message modified hook                */
INT updtype,                       /*   how message was updated code       */
const struct message *msg,         /*   message header                     */
const CHAR *text)                  /*   message text                       */
{
     INT i;
     size_t len;
     adr_t *echo;
     CHAR tmpbuf[sizeof(CMSG_MODIFY " 1234567890 1234567890")];

     if (wlExpActive && !impModifying && updtype == UPDMSG_MODFY
      && msg->forum != EMLID && sameas(msg->from,gmexinf())) {
          getdefb(msg->forum,&fdef);
          echo=(adr_t *)fdef.echoes;
          for (i=0 ; i < fdef.necho ; ++i) {
               if (sameto(wfpfx,echo[i]) && getNetModOut(skppfx(echo[i]))) {
                    stlcpy(tmpbuf,CMSG_MODIFY " ",sizeof(tmpbuf));
                    stlcat(tmpbuf,wlmGlobIDStr(&msg->gmid),sizeof(tmpbuf));
                    *wlHdrBuf='\0';
                    setWLHeader(wlHdrBuf,WLH_CONTROL,tmpbuf,WLMAXHDR);
                    setWLHeader(wlHdrBuf,WLH_FORUM,skppfx(echo[i]),WLMAXHDR);
                    setWLHeader(wlHdrBuf,WLH_FROM,fixExpAddr(msg->from),WLMAXHDR);
                    setWLHeader(wlHdrBuf,WLH_TOPIC,msg->topic,WLMAXHDR);
                    len=wlmSetSectStr(wlMsgBuf,0,MSGBUFSIZ,HDRSECT,wlHdrBuf);
                    len=wlmSetSectStr(wlMsgBuf,len,MSGBUFSIZ,TXTSECT,text);
                    addMsg2Stor(outStor,0L,wlMsgBuf,len,outDir,NULL);
                    rtkick(1,sndStart);
                    return;
               }
          }
     }
}

CHAR *
tvWLAddr(VOID)                     /* current user's WL address textvar    */
{
     static CHAR retbuf[MAXADR];

     if (wlExpActive && wlUseEmail && usaptr != NULL
      && isuidc(*usaptr->userid)) {
          stlcpy(retbuf,wlpfx,MAXADR);
          return(stlcat(retbuf,worUseridMake(usaptr->userid),MAXADR));
     }
     return("");
}

CHAR *
tvEmlPrefix(VOID)                  /* WorldLink e-mail prefix textvar      */
{
     if (wlExpActive && wlUseEmail) {
          return(wlpfx);
     }
     return("");
}

CHAR *
tvForPrefix(VOID)                  /* WorldLink forums prefix textvar      */
{
     static CHAR retbuf[PFXSIZ+1];

     if (wlExpActive) {
          stlcpy(retbuf,wfexp.prefix,sizeof(retbuf));
          return(stlcat(retbuf,":",sizeof(retbuf)));
     }
     return("");
}

const CHAR *
wlhlp(VOID)                        /* Worldlink email help message         */
{
     return(expHelp(WLHELP));
}

GBOOL
wlval(                             /* Worldlink exporter address validator */
const CHAR *addr)                  /*   address to check                   */
{
     const CHAR *cp;

     if (!wlExpActive || !wlUseEmail) {
          return(FALSE);
     }
     return(wlmIsInetAddr(addr)
         || ((cp=strchr(addr,'@')) != NULL && isRegNo(cp)));
}

const CHAR *                       /*   returns pointer to temp buffer     */
wlasp(                             /* Worldlink email attachment path      */
const CHAR *to,                    /*   destination address                */
const struct message *msg)         /*   message header                     */
{
     (VOID)to;
     (VOID)msg;
     if (wlExpActive && wlUseEmail) {
          return(makeOutFile(tmpanam(NULL)));
     }
     return("");
}

INT                                /*   returns GME status code            */
wlsnd(                             /* Worldlink email exporter             */
const CHAR *to,                    /*   destination address                */
const struct message *msg,         /*   GME message header                 */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt)                /*   attachment path+file name (if any) */
{
     if (!wlExpActive || !wlUseEmail) {
          return(GMEERR);
     }
     return(expMsg(NULL,to,msg,text,filatt));
}

const CHAR *
wfhlp(VOID)                        /* Worldlink forums help message        */
{
     return(expHelp(WFHELP));
}

INT                                /*   returns GME status code            */
wfsnd(                             /* Worldlink forum exporter             */
const CHAR *forum,                 /*   Worldlink forum name               */
const struct message *msg,         /*   GME message header                 */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt)                /*   attachment path+file name (if any) */
{
     CHAR to[MAXADR];

     if (!wlExpActive) {
          return(GMEERR);
     }
     stlcpy(to,fixExpAddr(msg->to),MAXADR);
     return(expMsg(forum,to,msg,text,filatt));
}

const CHAR *
expHelp(                           /* exporter help message utility        */
INT msgNum)                        /*   .MCV message number                */
{
     CHAR *cp;

     if (!wlExpActive) {
          return("");
     }
     setmbk(wlmb);
     cp=getMsgBlk(msgNum);
     rstmbk();
     return(cp);
}

INT
expMsg(                            /* export a message in WL format        */
const CHAR *forum,                 /*   forum for msg (NULL if email)      */
const CHAR *to,                    /*   user directed to                   */
const struct message *msg,         /*   GME message header                 */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt)                /*   path+file name of attachment       */
{
     size_t len;
     const CHAR *from;

     from=fixExpAddr(msg->from);
     if ((len=makeTransitMsg(wlMsgBuf,MSGBUFSIZ,forum,to,from,msg,text,
                             gmeGetAppInfo())) == 0) {
          return(GMEERR);
     }
     if (forum == NULL && impInProg) {  /* message autoforwarded */
          wlmGetSectStr(wlHdrBuf,WLMAXHDR,HDRSECT,wlMsgBuf,len);
          if (impCurHops != 0) {
               setWLHeader(wlHdrBuf,WLH_HOPS,l2as((LONG)impCurHops),WLMAXHDR);
          }
          ASSERT(impOrgDate != NULL);
          setWLHeader(wlHdrBuf,WLH_DATE,impOrgDate,WLMAXHDR);
          len=wlmSetSectStr(wlMsgBuf,len,MSGBUFSIZ,HDRSECT,wlHdrBuf);
     }
     if (!(msg->flags&FILATT)) {
          filatt=NULL;
     }
     if (!addMsg2Stor(outStor,0L,wlMsgBuf,len,outDir,filatt)) {
          return(GMEERR);
     }
     sndStart();
     return(GMEOK);
}

const CHAR *                       /*   returns temp buffer                */
fixExpAddr(                        /* make address into export format      */
const CHAR *orgAddr)               /*   original address                   */
{
     static CHAR retbuf[MAXADR];

     if (islocal(orgAddr)) {
          return(stlcpy(retbuf,worUseridMake(orgAddr),MAXADR));
     }
     if (wlmIsNativeAddr(orgAddr)) {
          return(stlcpy(retbuf,skppfx(orgAddr),MAXADR));
     }
     return(orgAddr);
}

GBOOL
wlmIsNativeAddr(                   /* is this a WL or SMTP address         */
const CHAR *addr)                  /*   address to examine                 */
{
     return((wlUseEmail && sameto(wlpfx,addr))
         || (*inpfx != '\0' && sameto(inpfx,addr)));
}
