/***************************************************************************
 *                                                                         *
 *   WLMCSMC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client management module (C/S).                   *
 *                                                                         *
 *                                            - J. Alvrus   3/12/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMCSMC_H
#define __WLMCSMC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define FAF_ISCFG 0x0100           /* forum list is-configured flag        */

extern GBOOL wlMgrActive;          /* has management module been init?     */
extern CHAR wlForumList[GCMAXPTH]; /* path & file name of all forums list  */
extern INT fcpypc;                 /* forums to copy to list file/cycle    */
extern INT faddpc;                 /* forums to add to list file/cycle     */
extern INT fchkpc;                 /* max forums to check per cycle        */

GBOOL
initCSMgr(VOID);                   /* initialize management module         */

VOID
closeCSMgr(VOID);                  /* shut down management module          */

VOID
statUpdate(VOID);                  /* system status has changed            */

VOID
infoChangeCS(VOID);                /* forum list or global info changed    */

VOID
setGlobalInfo(                     /* save global hub info                 */
const CHAR *info);                 /*   info string from hub               */

const CHAR *
getGlobalInfo(VOID);               /* get saved global hub info            */

VOID
mopResp(                           /* got response to management operation */
INT reqid,                         /*   request ID getting response        */
const CHAR *value);                /*   info returned by hub               */

VOID
mopAbort(                          /* management operation aborted         */
INT reqid,                         /*   request ID getting response        */
INT reason);                       /*   reason for abort                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMCSMC_H
