/***************************************************************************
 *                                                                         *
 *   WLMCLI.C                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging Client.                                           *
 *                                                                         *
 *                                            - J. Alvrus   1/14/97        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gme.h"
#include "wormsg.h"
#include "wlmutl.h"
#include "wlmstoru.h"
#include "wlmstorc.h"
#include "wlmforu.h"
#include "wlmmsgu.h"
#include "wlminsu.h"
#include "wlmcfgc.h"
#include "wlmimpc.h"
#include "wlmexpc.h"
#include "wlmmodc.h"
#include "wlmcsmc.h"
#ifndef GCDOS
#include "wlmahmc.h"
#endif // GCDOS
#include "wlmcli.h"

#define FILREV "$Revision: 11 $"

DFAFILE *wlfbb;                    /* Worldlink forum config data file     */

#if !defined(GCV2) && !defined(GCV30)
GBOOL (*oldckau)(CHAR *uid);       /* old allow new User-ID?               */

GBOOL wlCheckNewUid(CHAR *uid);
#endif // GCV2

VOID closeAll(VOID);

VOID EXPORT
init__wormsg(VOID)                 /* initialize Worldlink mail client     */
{
     GBOOL fnd;
     struct ffblk fb;

     init__galme();
     worInitialize();
     
     wlmb=opnmsg(MCVNAM);
     if (!initMsgUtil()
      || !initCliStor()
      || !initInStor()
      || !initForCfg()
      || !initExp()
      || !initImp()
      || !initWLModule()
#ifdef GCDOS
      || !initCSMgr()) {
#else
      || !initCSMgr()
      || !initAHMgr()) {
#endif // GCDOS
          closeAll();
          return;
     }
     if (ynopt(USEXRF)) {
          initForXref();
     }
     hook_shutdown(closeAll);
#if !defined(GCV2) && !defined(GCV30)
     oldckau=chkauid;
     chkauid=wlCheckNewUid;
#endif // GCV2
     for (fnd=fnd1st(&fb,makeOutFile("*.tmp"),0) ; fnd ; fnd=fndnxt(&fb)) {
          unlink(makeOutFile(fb.ff_name));
     }
     for (fnd=fnd1st(&fb,makeInFile("*.tmp"),0) ; fnd ; fnd=fndnxt(&fb)) {
          unlink(makeInFile(fb.ff_name));
     }
     wlActive=TRUE;
}

#if defined( WEBCAST )

VOID EXPORT
initwc__wormsg(VOID)                 /* initialize Worldlink mail client     */
{
     init__wormsg();
}

#endif

VOID
closeAll(VOID)                     /* shut down Worldlink mail client      */
{
#ifndef GCDOS
     closeAHMgr();
#endif // GCDOS
     closeCSMgr();
     closeWLModule();
     closeImp();
     closeExp();
     closeForCfg();
     closeInStor();
     closeCliStor();
     closeMsgUtil();
     closeForXref();
     clsmsg(wlmb);
     wlActive=FALSE;
}

#if !defined(GCV2) && !defined(GCV30)
GBOOL
wlCheckNewUid(                     /* allow new User-ID?                   */
CHAR *uid)                         /*   User-ID to check                   */
{
     if (sameas(WLPOSTM,uid)) {
          return(FALSE);
     }
     return((*oldckau)(uid));
}
#endif // GCV2

/* miscellaneous side-dependent utilities */

USHORT                             /*   forum ID or EMLID if not found     */
getWLForumID(                      /* get forum ID associated w/WL forum   */
const CHAR *forName)               /*   Worldlink forum name               */
{
     INT i,j,nfor;
     const adr_t *echo;
     const struct fordef *fdef;

     if (wlXrefActive) {
          if ((i=xrfForumIdx(forName)) >= 0) {
               return(xrfList[i]->forum);
          }
     }
     else {
          nfor=numforums();
          for (i=0 ; i < nfor ; ++i) {
               fdef=fiddefp(i);
               echo=(const adr_t *)fdef->echoes;
               for (j=0 ; j < fdef->necho ; ++j) {
                    if (sameto(wfpfx,echo[j])
                     && sameas(forName,skppfx(echo[j]))) {
                         return(fdef->forum);
                    }
               }
          }
     }
     return(EMLID);
}

GBOOL
xrfUseEcho(                        /* add this echo to crossreference?     */
const CHAR *echo)                  /*   echo address to check              */
{
     return(sameto(wfpfx,echo));
}

VOID
xrfChanged(VOID)                   /* notification of WL forum change      */
{
     infoChangeCS();
#ifndef GCDOS
     infoChangeAH();
#endif /* GCDOS */
}

VOID
xrfDeleting(                       /* notification of WL forum deleted     */
USHORT forum,                      /*   GME forum ID deleted (already gone)*/
const CHAR *name)                  /*   WL name of deleted forum           */
{
     /* not used by client */
     (VOID)forum;
     (VOID)name;
}

#ifdef DEBUG
VOID
LOG(const CHAR *s)
{
     FILE *fp;

     if (isfile(LOGFLAG) && (fp=fopen(LOGFILE,FOPAA)) != NULL) {
          fprintf(fp,"%s %s",
                  prndat(7,today(),'-'),prntim(10,now()));
          if (s != NULL) {
               fprintf(fp,", %s",s);
          }
          fputc('\n',fp);
          fclose(fp);
     }
}
#endif // DEBUG