/***************************************************************************
 *                                                                         *
 *   WLMCFGU.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging forum configuration utility declarations.         *
 *                                                                         *
 *                                            - J. Alvrus   3/31/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMCFGU_H
#define __WLMCFGU_H

#include "gcomm.h"
#include "wlmutl.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

                                   /* forum configuration sections         */
#define WFS_DESC    "Description"  /*   detailed description of forum      */

                                   /* WL Forums common config keywords     */
#define WFK_NAME    "Name"         /*   name of forum                      */
#define WFK_TOPIC   "Topic"        /*   topic of forum                     */
#define WFK_ACCESS  "Access"       /*   access (of system or privileged)   */

                                   /* forum access attribute flags         */
#define FAF_VIEW    1              /*   user can view forum                */
#define FAF_READ    2              /*   user can read from forum           */
#define FAF_WRITE   4              /*   user can post in forum             */
#define FAF_MANAGE  8              /*   user can manage forum              */
#define FAF_DEFAULT 0x8000         /*   use default access (don't override)*/
#define FAF_ALL (FAF_VIEW|FAF_READ|FAF_WRITE|FAF_MANAGE)
#define FAF_VALID (FAF_VIEW|FAF_READ|FAF_WRITE|FAF_MANAGE|FAF_DEFAULT)

                                   /* WL forum general info keywords       */
#define WIK_MAXCRT  "Max-Create"   /*   maximum forums a client can create */
#define WIK_UBRANCH "User-Branch"  /*   branch for user-created forums     */

extern struct cfgrec {             /* forum configuration record structure */
     USHORT hash;                  /*   hash of forum name                 */
     USHORT tiebrk;                /*   tie breaker (in case of collision) */
     CHAR name[MAXFNAM];           /*   forum name                         */
     CHAR config[1];               /*   buffer for configuration items     */
} *curcfg;                         /* cache for last-used forum            */

struct cfgkey {                    /* forum configuration data file key    */
     USHORT hash;                  /*   hash of forum name                 */
     USHORT tiebrk;                /*   tie breaker (in case of collision) */
};

extern DFAFILE *cfgbb;             /* forum configuration data file        */
extern size_t cfgmax;              /* max configuration record size        */

VOID
openCfg(                           /* open configuration file              */
const CHAR *fileName,              /*   data file name                     */
size_t maxrec);                    /*   maximum record size                */

VOID
closeCfg(VOID);                    /* close configuration file             */

GBOOL
isCfg(                             /* has named forum been configured?     */
const CHAR *name);                 /*   name of forum to check             */

CHAR *                             /*   returns pointer to destination     */
getCfg(                            /* get configuration info               */
CHAR *dst,                         /*   buffer to receive result           */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *name);                 /*   name of WL forum                   */

CHAR *                             /*   ptr to internal buf (NULL if err)  */
getCfgPtr(                         /* get pointer to configuration info    */
const CHAR *name);                 /*   name of WL forum                   */

CHAR *                             /*   returns pointer to destination     */
getCfgItem(                        /* get configuration item for a forum   */
CHAR *dst,                         /*   buffer to receive result           */
size_t dstSiz,                     /*   size of destination buffer         */
const CHAR *name,                  /*   name of WL forum                   */
const CHAR *sect,                  /*   configuration section name         */
const CHAR *kwd,                   /*   configuration item keyword         */
const CHAR *dft);                  /*   default value for item             */

GBOOL                              /*   returns TRUE if able to set        */
setCfgItem(                        /* set a configuration item for a forum */
const CHAR *name,                  /*   name of WL forum                   */
const CHAR *sect,                  /*   configuration section name         */
const CHAR *kwd,                   /*   config item keyword (NULL for all) */
const CHAR *val);                  /*   new value for item (NULL to clear) */

GBOOL                              /*   returns TRUE if room in config buf */
editCfg(                           /* edit configuration info for a forum  */
CHAR *src,                         /*   config str w/ items to change      */
const CHAR *name);                 /*   name of WL forum                   */

VOID
clearCfg(                          /* delete all config info for a forum   */
const CHAR *name);                 /*   name of WL forum                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMCFGU_H