/***************************************************************************
 *                                                                         *
 *   WLMCFGC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging client-side forum configuration utility           *
 *   declarations.                                                         *
 *                                                                         *
 *                                            - J. Alvrus   3/11/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __WLMCFGC_H
#define __WLMCFGC_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define CFGFILE "wormsgc2.dat"     /* forum configuration data file name   */
#define WLMAXFCFG 2048             /* largest config buffer size           */
#define MAXMAXATT 2097151L         /* maximum maximum attachment size      */

                                   /* standard forum config keywords       */
#define FC_APVATT  "Auto-Approve"  /*   auto-approve attachments           */
#define FC_MAXATT  "Attachment-Size-Limit" /* max att size (kb, -1 = unlim)*/
#define FC_NETCANI "Net-Cancel-In" /* allow incoming network cancellation  */
#define FC_NETCANO "Net-Cancel-Out"/* allow outgoing network cancellation  */
#define FC_NETMODI "Net-Modify-In" /* allow incoming network modification  */
#define FC_NETMODO "Net-Modify-Out"/* allow outgoing network modification  */

extern GBOOL wlCfgActive;          /* has config util been initialized?    */

                                   /* default configuration settings       */
extern GBOOL dftAutoApv;           /*   auto-approve attachments           */
extern LONG dftMaxEmlAtt;          /*   max email att size (kb, -1 = unlim)*/
extern LONG dftMaxForAtt;          /*   max forum att size (kb, -1 = unlim)*/
extern GBOOL dftNetCanIn;          /*   allow incoming network cancellation*/
extern GBOOL dftNetCanOut;         /*   allow outgoing network cancellation*/
extern GBOOL dftNetModIn;          /*   allow incoming network modification*/
extern GBOOL dftNetModOut;         /*   allow outgoing network modification*/

GBOOL
initForCfg(VOID);                  /* initialize forum configuration util  */

VOID
closeForCfg(VOID);                 /* shut down forum configuration utility*/

GBOOL
getAutoApv(                        /* get auto-approve setting             */
const CHAR *name);                 /*   for this forum                     */

LONG
getMaxForAtt(                      /* get max forum attachment size setting*/
const CHAR *name);                 /*   for this forum                     */

GBOOL
getNetCanIn(                       /* get incoming network cancel setting  */
const CHAR *name);                 /*   for this forum                     */

GBOOL
getNetCanOut(                      /* get outgoing network cancel setting  */
const CHAR *name);                 /*   for this forum                     */

GBOOL
getNetModIn(                       /* get incoming network modify setting  */
const CHAR *name);                 /*   for this forum                     */

GBOOL
getNetModOut(                      /* get outgoing network modify setting  */
const CHAR *name);                 /*   for this forum                     */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WLMCFGC_H