/***************************************************************************
 *                                                                         *
 *   WLMCFGC.C                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Worldlink Messaging client-side forum configuration management        *
 *   utilities.                                                            *
 *                                                                         *
 *                                            - J. Alvrus   3/11/97        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "wlmcfgu.h"
#include "wlmcfgc.h"
#include "wormsg.h"

#define FILREV "$Revision: 4 $"

GBOOL wlCfgActive=FALSE;           /* has config util been initialized?    */

                                   /* default configuration settings       */
GBOOL dftAutoApv;                  /*   auto-approve attachments           */
LONG dftMaxEmlAtt;                 /*   max email att size (kb, -1 = unlim)*/
LONG dftMaxForAtt;                 /*   max forum att size (kb, -1 = unlim)*/
GBOOL dftNetCanIn;                 /*   allow incoming network cancellation*/
GBOOL dftNetCanOut;                /*   allow outgoing network cancellation*/
GBOOL dftNetModIn;                 /*   allow incoming network modification*/
GBOOL dftNetModOut;                /*   allow outgoing network modification*/

GBOOL
initForCfg(VOID)                   /* initialize forum configuration util  */
{
     openCfg(CFGFILE,WLMAXFCFG);
     dftAutoApv=ynopt(AUTAPV);
     dftMaxEmlAtt=ynopt(LIMEATT) ? lngopt(MAXEASZ,0,MAXMAXATT) : -1L;
     dftMaxForAtt=ynopt(LIMFATT) ? lngopt(MAXFASZ,0,MAXMAXATT) : -1L;
     dftNetCanIn=ynopt(NETCANI);
     dftNetCanOut=ynopt(NETCANO);
     dftNetModIn=ynopt(NETMODI);
     dftNetModOut=ynopt(NETMODO);
     wlCfgActive=TRUE;
     return(TRUE);
}

VOID
closeForCfg(VOID)                  /* shut down forum configuration utility*/
{
     if (wlCfgActive) {
          closeCfg();
     }
     wlCfgActive=FALSE;
}

/* encapsulated standard configuration items */

GBOOL
getAutoApv(                        /* get auto-approve setting             */
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_APVATT,l2as((LONG)dftAutoApv))));
}

LONG
getMaxForAtt(                      /* get max forum attachment size setting*/
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_MAXATT,l2as(dftMaxForAtt))));
}

GBOOL
getNetCanIn(                       /* get incoming network cancel setting  */
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_NETCANI,l2as((LONG)dftNetCanIn))));
}

GBOOL
getNetCanOut(                      /* get outgoing network cancel setting  */
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_NETCANO,l2as((LONG)dftNetCanOut))));
}

GBOOL
getNetModIn(                       /* get incoming network modify setting  */
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_NETMODI,l2as((LONG)dftNetModIn))));
}

GBOOL
getNetModOut(                      /* get outgoing network modify setting  */
const CHAR *name)                  /*   for this forum                     */
{
     CHAR numBuf[sizeof("1234567890")];

     return(atoi(getCfgItem(numBuf,sizeof(numBuf),name,NULL,
                            FC_NETMODO,l2as((LONG)dftNetModOut))));
}
