/////////////////////////////////////////////////////////////////////////////
//
//   TLCWORS.CPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Worldlink Teleconference Extension
//   Common Hub/Client SMB functions
//                                               - Phil Henning 7/7/97
//
/////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.h"
#include "worldsrv.h"
#include "tlcworh.h"

#define FILREV "$ Revision: 1 $"

MARKSOURCE(tlcsmbu);

INT
smbCompareUSHORT(
const VOID* target,
const VOID* test)
{
     USHORT num1;
     USHORT num2;

     num1=*(static_cast<USHORT *>(const_cast<VOID*>(target)));
     num2=*(static_cast<USHORT *>(const_cast<VOID*>(test)));

     return((num1 == num2 ? EQUAL :  num1 > num2 ? LEFTHIGH : RIGHTHIGH));
}

INT
smbCompareULONG(
const VOID* target,
const VOID* test)
{
     ULONG num1;
     ULONG num2;

     num1=*(static_cast<ULONG *>(const_cast<VOID*>(target)));
     num2=*(static_cast<ULONG *>(const_cast<VOID*>(test)));

     return((num1 == num2 ? EQUAL :  num1 > num2 ? LEFTHIGH : RIGHTHIGH));
}

SMBKEYTABLE smbUserSmbKey[]= {
    {offsetof(jinfstr,unum),smbCompareULONG},
    {offsetof(jinfstr,Nodenumber),smbCompareUSHORT},
    {0,NULL}
};

SMBKEYTABLE smbUserFlagsSmbKey[]= {
    {offsetof(wusrflags,unum),smbCompareULONG},
    {0,NULL}
};

