//
//   TLCWORH.H
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Worldlink Teleconference Extension
//   Common Server/Client Declarations
//                                               - Phil Henning 7/7/97
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __TLCWORH_H
#define __TLCWORH_H

#include "tlcapi.h"
#include "smbwrap.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define WORAPID     "GALWORTLC"
#define WORAPNM     "WorldLink Teleconference"

#define ACTTOALL    0xFFFFFFFFUL

typedef struct worchn {
    SHORT chn;
    SHORT rating;
    CHAR worID[WBOASIZ];
    CHAR chnName[CHAN_MAX_SIZE];
    CHAR name[BBSSIZ];
    CHAR topic[CHAN_MAX_TOPIC_SIZE];
} WORCHN, *LPWORCHN;

#define worsndbuf           ((struct speakinf*)worbuf)
#define WORSNDBUFSIZ        WBUFSZ

extern CHAR* tlcworbuf;

typedef struct speakinf {
    CHAR ptr1[TLCUIDSIZ];
    SHORT chn;
    SHORT type;
    SHORT iMsgNum;
    ULONG unumFrom;
    ULONG unumTo;
    CHAR ptr2[TLCUIDSIZ];
    CHAR ptr3[TLCUIDSIZ];
    CHAR msg[1];
} SPEAKINF, *LPSPEAKINF;

typedef struct actioninf {
    CHAR fmt[RESSIZ];
    CHAR rate[WRATSIZ];
    CHAR name[ACTSIZ];
    GBOOL isyell;
    GBOOL iscomplex;
    SHORT chn;
    ULONG from;
    ULONG to;
    CHAR extra[1];
} ACTIONINF, *LPACTIONINF;

typedef struct jinfstr {
    SHORT chn;
    SHORT Nodenumber;
    ULONG unum;
    ULONG tlcunum;
    GBOOL inital;
} JINFSTR, *LPJINFSTR;


typedef struct usrmods {
    USHORT board;
    USHORT boardfrom;
    INT usrnum;
    CHAR data[1] ;
} USRMODS, *LPUSRMODS;

typedef struct worchat {
     ULONG unumFrom;
     ULONG unumTo;
     SHORT error;
} WORCHAT, *LPWORCHAT;

#define WORUSR_UNLIST  0x00000001

typedef struct wusrflags {
    ULONG unum;
    ULONG flags;
} USRFLAGS, *LPUSRFLAGS;

extern CHAR* primaryList;
extern CHAR* primaryRating;
extern CHAR* secondaryList;
extern CHAR* secondaryRating;

INT
smbCompareUSHORT(
const VOID* target,
const VOID* test);

INT
smbCompareULONG(
const VOID* target,
const VOID* test);

extern SMBKEYTABLE smbUserSmbKey[];
extern SMBKEYTABLE smbUserFlagsSmbKey[];

enum {
    NOCMD,              WORCMD_CREATE_CHANNEL,      WORCMD_DELETE_CHANNEL,
    WORCMD_GETCHAN,     WORCMD_PUBLIC_SEND,         WORCMD_PRIVATE_SEND,
    WORCMD_USER_JOIN,   WORCMD_USER_UNJOIN,         WORCMD_REMOVE_NODE_USERS,
    WORCMD_GETUSERS,    WORCMD_USERMODS,            WORCMD_USERMODS_REPLY,
    WORCMD_INVISTOGGLE, WORCMD_ADDUSER,             WORCMD_REMOVEUSER,
    WORCMD_USER_REJOIN, WORCMD_ACTION,              WORCMD_PRIVATE_ACTION,
    WORCMD_ACTION_NOACS,WORCMD_ACTION_REQUEST,      WORCMD_ACTION_NOUSR,
    WORCMD_USERMODS_NOTELE, WORCMD_ACTION_IGNORE,   WORCMD_ACTION_FORGET,
    WORCMD_CHAT_NOTIFY, WORCMD_CHAT_ACCEPT,         WORCMD_CHAT_NOTIFYERROR,
    WORCMD_CHAT_NOTINTELE, WORCMD_CHAT_DONE,        WORCMD_CHAT_NOTAVAIL,
    WORCMD_USER_UNLISTED
};
#ifdef __cplusplus
};
#endif // __cplusplus
#endif // __TLCWORH_H

