/////////////////////////////////////////////////////////////////////////////
//
//   TLCWORCH.H
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Worldlink Teleconference Channel
//   Declaration
//                                               - Phil Henning 7/15/97
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __TLCWORCH_H
#define __TLCWORCH_H
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define CHAN_TYPE_WL_PUBLIC     0x0100

typedef struct wchancustom {
    SHORT num;
    CHAR  pszNode[WBOASIZ];
    SHORT rating;
} WORCHANCUSTOM, *LPWORCHANCUSTOM;

extern CHFUNCPTRS worChannel;

#define ACTION_NOACS  1
#define ACTION_NOUSR  2
#define ACTION_IGNORE 3
#define ACTION_FORGET 4


SHORT
WorChAddUser(
const CHAR* channel,
LPUSRSTRUCT pUser,
GBOOL bIsFirstEnter);

SHORT
WorChRemoveUser(
const CHAR* channel,
LPUSRSTRUCT pUser,
SHORT fExitType);

VOID
WorChPreWelcome(
LPUSRSTRUCT pUser);

VOID
WorChAddNetworkUser(
const CHAR* channel,
const CHAR* userid);

VOID
WorChRemoveNetworkUser(
const CHAR* channel,
const CHAR* userid);

VOID
WorChWLRecv(
const CHAR* channel,
const CHAR* pszUseridFrom,
const CHAR* pszUseridTo,
const CHAR* pMsg,
SHORT fType,
SHORT iMsgNum,
const CHAR* ptr1,
const CHAR* ptr2,
const CHAR* ptr3);

VOID
WorChWLAction(
LPACTIONINF pAct,
const CHAR* channel);

SHORT
WorChWLActionUser(
LPACTIONINF pAct,
const CHAR* user,
const CHAR* channel,
GBOOL secret);

GBOOL                              //   TRUE/FALSE
WorCanAccess(                      // can user access channel
const CHAR* channel,               //   channel name
LPUSRSTRUCT pUser,                 //   user structure
INT access);                       //   access being requested

#ifdef __cplusplus
};
#endif //__cplusplus
#endif //__TLCWORCH_H
