/***************************************************************************
 *                                                                         *
 *   ABOUTOS.C                                                             *
 *                                                                         *
 *   Copyright (C) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Operating system information routines for NT.                         *
 *                                                                         *
 *                                        - Ilya Minkin 01/26/96           *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 6 $"

VOID
aboutos(VOID)                      /* OS specific about information        */
{
     OSVERSIONINFO versionInfo;
     SYSTEM_INFO systemInfo;

     versionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
     GetVersionEx(&versionInfo);
     GetSystemInfo(&systemInfo);
     if (versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
          setatr(0x1E);
          printfat(21,8,"Windows NT v%d.%d (Build %d)",
                         versionInfo.dwMajorVersion,
                         versionInfo.dwMinorVersion,
                         versionInfo.dwBuildNumber);
          setatr(0x1D);
          printfat(5,9,"Processor Type: ");
          setatr(0x1E);
          switch(systemInfo.u.s.wProcessorArchitecture) {
          case PROCESSOR_ARCHITECTURE_INTEL:
               printf("Intel ");
               switch(systemInfo.dwProcessorType) {
               case PROCESSOR_INTEL_386:
                    printf("80386");
                    break;
               case PROCESSOR_INTEL_486:
                    printf("80486");
                    break;
               case PROCESSOR_INTEL_PENTIUM:
                    printf("Pentium");
                    break;
               default:
                    printf("Unknown Type");
                    break;
               }
               break;
          case PROCESSOR_ARCHITECTURE_MIPS:
               printf("MIPS");
               break;
          case PROCESSOR_ARCHITECTURE_ALPHA:
               printf("ALPHA");
               break;
          case PROCESSOR_ARCHITECTURE_PPC:
               printf("PPC ");
               break;
          case PROCESSOR_ARCHITECTURE_UNKNOWN:
          default:
               printf("UNKNOWN");
               break;
          }
          printf(" (%d Processor%s)",systemInfo.dwNumberOfProcessors,
                 systemInfo.dwNumberOfProcessors == 1 ? "" : "s");
          setatr(0x1D);
          printfat(5,10,"Execution Mode: ");
          setatr(0x1E);
          printf("NT %s",isRunAsService() ? "Service" : "Application");
     }
     else {
          setatr(0x1E);
          printfat(21,8,"Windows 95 v%d.%d (Build %d)",
                         versionInfo.dwMajorVersion,
                         versionInfo.dwMinorVersion,
                         LOWORD(versionInfo.dwBuildNumber));
          setatr(0x1D);
          printfat(5,9,"Processor Type: ");
          setatr(0x1E);
          printf("Intel ");
          switch (systemInfo.dwProcessorType) {
          case PROCESSOR_INTEL_386:
               printf("80386 ");
               break;
          case PROCESSOR_INTEL_486:
               printf("80486 ");
               break;
          case PROCESSOR_INTEL_PENTIUM:
               printf("Pentium ");
               break;
          default:
               printf("Unknown Type ");
               break;
          }
          printf("(1 Processor)");
     }
}
