/***************************************************************************
 *                                                                         *
 *   WGSVBCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   System Variable conversion utility for WGSVBL2.DAT.                   *
 *                                                                         *
 *                                           - Bill Hyatt     07/08/96     *
 *                                           - Wally Muharsky 11/19/97     *
 ***************************************************************************/
#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "dfcapi.h"
#include "dfcapi2.h"

#define OVBRECSZ    3076           /*  MAX Size of old sysvar struct       */
#define NGROUPS     17             /*  Number of channel groups from old   */

/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
static DFCFUNCTION                 /*  Pointer to data                     */
ConversionDOS1(                    /* Converstion from BBSVBL to WGSVBL2   */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to);                  /*  Pointer to to data                  */

static DFCFUNCTION                 /*  Pointer to data                     */
PlatformConvert(                   /* Converstion from BBSVBL to WGSVBL2   */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to);                  /*  Pointer to to data                  */

static DFCFUNCTION                 /*  Pointer to data                     */
ConversionVBL(                     /* Converstion function                 */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to,                   /*  Pointer to to data                  */
GBOOL EatOldCreds,                 /*  Eat old credits up?                 */
GBOOL TakeLongs,                   /*  Take variables as longs? (or shorts)*/
INT nGrp);                         /*  Number of groups                    */

static GBOOL bFromDos2=FALSE;      /*  Converted from DOS 2                */
/***************************************************************************
 * File Layouts                                                            *
 ***************************************************************************/
static DFCDATAFIELDS bbsvbl[]={
     {"KEY",        DFCFLD_CHAR,   4,             NULL},
     {"VARSTUFF",   DFCFLD_VCHAR,  OVBRECSZ-4,    NULL},
     {"", DFCFLD_END, NULL},
};

static DFCDATAFIELDS wgsvbl2[]={
     {"KEY",        DFCFLD_CHAR,   4,                       NULL},
     {"VARSTUFF",   DFCFLD_VCHAR,  sizeof(struct sysvb3)-4, NULL},
     {"", DFCFLD_END, NULL},
};


/***************************************************************************
 * Lists of files for OS's                                                 *
 ***************************************************************************/
static DFCFILE VariableDOS[]={
     {"BBSVBL",     NULL,               bbsvbl},
     {"WGSVBL2",    ConversionDOS1,     wgsvbl2},
     {"", NULL, NULL},
};

static DFCFILE VariableWNT[]={
     {"WGSVBL2",    NULL,               wgsvbl2},
     {"", NULL, NULL},
};


/***************************************************************************
 * File list definitions                                                   *
 ***************************************************************************/
static DFCLIST VariableList[]={
     {DFC_DOS, VariableDOS},
     {DFC_WNT, VariableWNT},
     {DFC_END, NULL},
};

static DFCPFCONVERT PlatformConverts[]={
     {DFC_DOS, DFC_WNT,  PlatformConvert},
     {DFC_END, DFC_END, NULL},
};

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
MARKSOURCE(wgsvbcvt);

INT
main(VOID)
{
TRY
     dfcRegister("Worldgroup Variables",VariableList,PlatformConverts,-1,DFC_FORWARD);
EXCEPT
     return(0);
}

/***************************************************************************
 * This function converts BBSVBL.DAT (DOS) to WGSVBL2.DAT (DOS)            *
 ***************************************************************************/
static DFCFUNCTION                 /*  Pointer to data                     */
ConversionDOS1(                    /* Converstion from BBSVBL to WGSVBL2   */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to)                   /*  Pointer to to data                  */
{
     bFromDos2=TRUE;
     return(ConversionVBL(from,to,TRUE,FALSE,NGROUPS));
}

static DFCFUNCTION                 /*  Pointer to data                     */
PlatformConvert(                   /* Converstion from BBSVBL to WGSVBL2   */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to)                   /*  Pointer to to data                  */
{
     if (bFromDos2) {
          memcpy(to->Data,from->Data,(to->DataLength=from->DataLength));
          return(to->Data);
     }
     else {
          return(ConversionVBL(from,to,FALSE,TRUE,NUMGRPS));
     }
}

static DFCFUNCTION                 /*  Pointer to data                     */
ConversionVBL(                     /* Converstion function                 */
pDFCFILEINFO from,                 /*  Pointer to from data                */
pDFCFILEINFO to,                   /*  Pointer to to data                  */
GBOOL EatOldCreds,                 /*  Eat old credits up?                 */
GBOOL TakeLongs,                   /*  Take variables as longs? (or shorts)*/
INT nGrp)                          /*  Number of groups                    */
{
     INT cvtflg;
     struct sysvbl *vbl1;
     struct sysvb2 *vbl2;
     struct sysvb3 *vbl3;

     takeInit(from->Data,from->DataLength,from->Type,to->Type);
     if (sameas(from->Data,"key") || sameas(from->Data,"old")) {
          vbl1=(struct sysvbl *)to->Data;
          cvtflg=takeChar(vbl1->key,4);
          cvtflg&=takeChar(vbl1->dspopt,6);
          cvtflg&=takeLong(vbl1->calls,8);
          cvtflg&=takeChar(vbl1->lonmsg,MTXSIZ);
          cvtflg&=takeLong(&vbl1->dwnlds,1);
          cvtflg&=takeLong(&vbl1->uplds,1);
          cvtflg&=takeLong(&vbl1->msgtot,1);
          cvtflg&=takeShort(&vbl1->emlopn,1);
          cvtflg&=takeShort(&vbl1->sigopn,1);
          cvtflg&=takeShort(&vbl1->hisign,1);
          cvtflg&=takeChar(&vbl1->monmal,1);
          cvtflg&=takeChar(&vbl1->savmin,1);
          to->DataLength=sizeof(struct sysvbl);
     }
     else if (sameas(from->Data,"ky2") || sameas(from->Data,"ol2")) {
          vbl2=(struct sysvb2 *)to->Data;
          cvtflg=takeChar(vbl2->ky2,4);
          cvtflg&=takeShort(vbl2->matrix,NCOMTY*NAGEBK);
          if (EatOldCreds) {
               // sv2.oldcrd[] now in sv3.crdghr[] (conversion from
               // 2.0 data files only)
               cvtflg&=takeLong(NULL,8*24);
          }
          cvtflg&=takeShort(vbl2->nliniu,48);
          cvtflg&=takeShort(&vbl2->lstzer,1);
          cvtflg&=takeLong(&vbl2->x25kps,1);
          cvtflg&=takeShort(&vbl2->x25ps,1);
          cvtflg&=takeLong(&vbl2->x25mbs,1);
          cvtflg&=takeLong(&vbl2->x25bs,1);
          // following fields are longs in 3.0 data file, shorts in 2.0
          if (TakeLongs) {
               cvtflg&=takeLong(&vbl2->numact,1);
               cvtflg&=takeLong(&vbl2->numfem,1);
               cvtflg&=takeLong(&vbl2->numcor,1);
               cvtflg&=takeLong(&vbl2->numans,1);
          }
          else {
               cvtflg&=takeShort(&vbl2->numact,1);
               cvtflg&=takeShort(&vbl2->numfem,1);
               cvtflg&=takeShort(&vbl2->numcor,1);
               cvtflg&=takeShort(&vbl2->numans,1);
          }
          cvtflg&=takeLong(&vbl2->paidpst,1);
          cvtflg&=takeLong(&vbl2->freepst,1);
          cvtflg&=takeLong(&vbl2->totcalls,1);
          cvtflg&=takeShort(&vbl2->lastmcu,1);
          to->DataLength=sizeof(struct sysvb2);
     }
     else if (sameas(from->Data,"ky3") || sameas(from->Data,"ol3")) {
          vbl3=(struct sysvb3 *)to->Data;
          cvtflg=takeChar(vbl3->ky3,4);
          cvtflg&=takeLong(vbl3->secghr,(nGrp-1)*24);
          cvtflg&=takeLong(vbl3->crdghr,(nGrp-1)*24);
          to->DataLength=sizeof(struct sysvb3);
     }
     else {
          catastro("WGSVBCVT: Unknown key value %s!",(CHAR*)from->Data);
     }
     if (!(cvtflg&1)) {
          catastro("WGSVBCVT: Error getting source data!");
     }
     return(to->Data);
}
