/***************************************************************************
 *                                                                         *
 *   WGSMNCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Menu Tree conversion utility.                                         *
 *                                                                         *
 *                                           - Bill Hyatt   7/8/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "dfcapi.h"

#define IDSTG "WGSMNCVT"           /* id stg for API calls                 */

/* following taken from (based on) DOS 2.0 version of MAJORBBS.H */

#define FNMSIZ      80             /* max size of a file (with path)       */
#define OMNRECSZ    3485     /* max size of old menu rec, fm struct mnupag */
/* end old MAJORBBS.H declarations */

#define DSTDAT ((struct mnupag *)dstbb->data)  /* cast for dest data       */

_NOSCNS_                           /* keep DFCDISP.C happy                 */

INT
main(INT argc,CHAR *argv[])
{
     INT cvtflg,i,srcflg=0,dstflg=0,srcFileRecSiz,fnameLen;
     SHORT npages,reclen;
     GBOOL fnd,eatSpare;
     ULONG totrec,currec;

TRY
     if (dfcCustInit(argc,argv,IDSTG) != 0) {
          catastro(dfcLastErr());
     }
#ifdef GCDOS
     srcFileRecSiz=OMNRECSZ;
     fnameLen=FNMSIZ;
     eatSpare=TRUE;
#else
     if (sameas(getUpdType(),"2.0 to NT")) {
          srcFileRecSiz=OMNRECSZ;
          fnameLen=FNMSIZ;
          eatSpare=TRUE;
     }
     else {
          srcFileRecSiz=sizeof(struct mnupag);
          fnameLen=GCSTRPTH;
          eatSpare=FALSE;
     }
#endif // GCDOS
     dfcOpenFiles(srcFileRecSiz,sizeof(struct mnupag));
     totrec=dfaCountRec();
     if (!dfcChkDskSpc(totrec*srcFileRecSiz)) {
          catastro(dfcLastErr());
     }
     if (dfcSupFlags(&srcflg,&dstflg) != 0) {
          catastro(dfcLastErr());
     }
     for (fnd=dfaStepLO(NULL),currec=0L ; fnd ; fnd=dfaStepNX(NULL)) {
          dfcDspRecs(++currec,totrec);
          memset(dstbb->data,0,sizeof(struct mnupag));
          takeInit(srcbb->data,dfaLastLen(),srcflg,dstflg);
          /* these calls based on struct mnupag from
             DOS 2.0 / DOS 3.0 / NT versions of MAJORBBS.H */
          cvtflg=takeChar(&DSTDAT->menutype,1);
          cvtflg&=takeChar(DSTDAT->pagnam,PNMSIZ);
          cvtflg&=takeChar(DSTDAT->parpag,PNMSIZ);
          cvtflg&=takeChar(DSTDAT->fname,fnameLen);
          cvtflg&=takeChar(DSTDAT->modnam,MNMSIZ);
          cvtflg&=takeChar(DSTDAT->cmdstg,CMDSIZ);
          cvtflg&=takeChar(DSTDAT->golock,KEYSIZ);
          cvtflg&=takeShort(&DSTDAT->flags,1);
          cvtflg&=takeChar(DSTDAT->mnuttl,TITLSZ);
          cvtflg&=takeShort(&DSTDAT->npages,1);
          cvtflg&=takeLong(&DSTDAT->ichange,1);
          if (eatSpare) {
               cvtflg&=takeChar(NULL,70);
          }
          npages=DSTDAT->npages;
          for (i=0 ; i < npages ; i++) {
               cvtflg&=takeShort(&DSTDAT->page[i].position,1);
               cvtflg&=takeChar(&DSTDAT->page[i].selchr,1);
               cvtflg&=takeChar(DSTDAT->page[i].iconame,FNSIZE);
               cvtflg&=takeChar(DSTDAT->page[i].destpage,PNMSIZ);
               cvtflg&=takeChar(&DSTDAT->page[i].optdsp,1);
               cvtflg&=takeChar(DSTDAT->page[i].keyreq,KEYSIZ);
               cvtflg&=takeChar(DSTDAT->page[i].shortd,SHDSIZ);
               cvtflg&=takeChar(DSTDAT->page[i].longd,LNDSIZ);
          }
          if (cvtflg&1) {
               dfaSetBlk(dstbb);
               reclen=fldoff(mnupag,page)+(npages*sizeof(struct pglink));
               dfaInsertV(NULL,reclen);
          }
          else {
               catastro("WGSMNCVT: Error getting source data!");
          }
          dfaSetBlk(srcbb);
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}
