/***************************************************************************
 *                                                                         *
 *   WGSGDCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Generic Dynapak Database custom conversion utility.                   *
 *                                                                         *
 *                                           - Bill Hyatt     8/5/96       *
 *                                           - Wally Muharsky 11/18/97     *
 ***************************************************************************/
#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "dfcapi2.h"

static DFCFUNCTION                 /*  Pointer to new data                 */
ConversionFunction(                /* Custom conversion function           */
pDFCFILEINFO from,                 /*  Info on data from                   */
pDFCFILEINFO to);                  /*  Info on data to                     */

/***************************************************************************
 *  Datafields for all file layouts                                        *
 ***************************************************************************/
static DFCDATAFIELDS saunam[]={
     {"SAUSYSID",   DFCFLD_CHAR,   SIDSIZ,   NULL},
     {"SAUAPPID",   DFCFLD_CHAR,   AIDSIZ,   NULL},
     {"SAUUSERID",  DFCFLD_CHAR,   UIDSIZ,   NULL},
     {"SAUFLAGS",   DFCFLD_CHAR,   1,        NULL},
     {"SAUSUFFIX",  DFCFLD_CHAR,   SFXSIZ,   NULL},
     {"", DFCFLD_END, 0, NULL},
};

static DFCDATAFIELDS GenericDB[]={
     {"SAUNAM",     DFCFLD_STRUCT, 1,        saunam},
     {"VARSTUFF",   DFCFLD_VCHAR,  MAXDPKV,  NULL},
     {"", DFCFLD_END, 0, NULL},
};

/***************************************************************************
 * Specific platform files                                                 *
 ***************************************************************************/
static DFCFILE GenericDOS[]={
     {"BBSERVER",   ConversionFunction,      GenericDB},
     {"WGSERV2",    ConversionFunction,      GenericDB},
     {"", NULL, NULL},
};

static DFCFILE GenericWNT[]={
     {"WGSERV2",    ConversionFunction,      GenericDB},
     {"",NULL,NULL},
};

/***************************************************************************
 *  List of files to check for converting                                  *
 ***************************************************************************/
static DFCLIST GenericList[]={
     {DFC_DOS, GenericDOS},
     {DFC_WNT, GenericWNT},
     {DFC_END, NULL}
};

static DFCPFCONVERT PlatformConvert[]={
     {DFC_DOS, DFC_WNT,  ConversionFunction},
     {DFC_END, DFC_END, NULL},
};

INT
main(VOID)
{
TRY
     dfcRegister("Generic Dynapak Database",GenericList,PlatformConvert,-1,DFC_FORWARD);
EXCEPT
     return(0);
}

static DFCFUNCTION                 /*  Pointer to new data                 */
ConversionFunction(                /* Custom conversion function           */
pDFCFILEINFO from,                 /*  Info on data from                   */
pDFCFILEINFO to)                   /*  Info on data to                     */
{
     CHAR* ans;
     pDFCOFFSETS toff;
     UINT SuffixOffset=0;
     UINT DataOffset=0;

     for (toff=to->Offsets; toff->Type != DFCFLD_END; toff++) {
          if (sameas(toff->Name,"SAUSUFFIX")) {
               SuffixOffset=toff->Offset;
          }
          if (sameas(toff->Name,"VARSTUFF")) {
               DataOffset=toff->Offset;
          }
     }
     if (SuffixOffset == 0 || DataOffset == 0) {
          return(NULL);
     }
     ans=(CHAR*)dfcConvertDefault(from,to);
     if (sameto("spcgdpk",&ans[SuffixOffset])) {
          cvtDataIP(&ans[SuffixOffset],
           sizeof(ULONG),
           sizeof(ULONG),
           longsFDA,
           from->Type,
           to->Type,
           CHAN_NUL);
     }
     return(ans);
}

