/***************************************************************************
 *                                                                         *
 *   WGSADCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Audit trail conversion program.                                       *
 *                                                                         *
 *                                        - W. Muharsky 12/03/97           *
 *                                                                         *
 ***************************************************************************/
#include "gcomm.h"
#include "majorbbs.h"
#include "dfcapi2.h"


/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
static CHAR *                      /*  Pointer to new stamp format         */
ConvertStamp(                      /* Convert from old to new style        */
const CHAR *stamp);                /*  Old style stamp                     */

INT
main(VOID);                        /*  Main routine                        */

static CHAR *                      /*  Pointer to new stamp format         */
ConvertStamp(                      /* Convert from old to new style        */
const CHAR *stamp);                /*  Old style stamp                     */

static DFCFUNCTION
AuditConvert(                      /*  Brings to most recent version       */
pDFCFILEINFO from,                 /*  Pointer to from information         */
pDFCFILEINFO to);                  /*  Pointer to TO information           */

static DFCFUNCTION
PlatformDummy(                     /*  Dummy routine (no conversion needed)*/
pDFCFILEINFO from,                 /*   No conversion is needed for the    */
pDFCFILEINFO to);                  /*   platform.  File is compat w/ both  */

/***************************************************************************
 * Data field information                                                  *
 ***************************************************************************/
static DFCDATAFIELDS AuditFields[]={
     {"AUDREC",     DFCFLD_CHAR,        132,      NULL},
     {"",DFCFLD_END,0,NULL},
};

/***************************************************************************
 * Audit Trail file lists                                                  *
 ***************************************************************************/
static DFCFILE AuditDOS[]={
     {"BBSAUDIT",   NULL,          AuditFields},
     {"WGSAUDT2",   NULL,          AuditFields},
     {"WGSAUDT3",   AuditConvert,  AuditFields},
     {"",NULL,NULL},
};

static DFCFILE AuditWNT[]={
     {"WGSAUDT2",   NULL,          AuditFields},
     {"WGSAUDT3",   AuditConvert,  AuditFields},
     {"",NULL,NULL},
};

static DFCLIST AuditList[]={
     {DFC_DOS,AuditDOS},
     {DFC_WNT,AuditWNT},
     {DFC_END,NULL},
};

static DFCPFCONVERT PlatformConvert[]={
     {DFC_DOS,DFC_WNT,PlatformDummy},
     {DFC_END,DFC_END,NULL},
};

//
//  *** NOTE:
//        WGSAUD3.VIR is used as a dummy file.  Once the conversion has
//        taken place, then the resulting DAT file is removed.
//

HAUDFILE auddat;

GBOOL AuditOpen=FALSE;

/***************************************************************************
 *  Source Code                                                            *
 ***************************************************************************/
MARKSOURCE(wgsadcvt);

INT
main(VOID)                         /*  Main routine                        */
{
     initvid();


     dfcRegister("Audit Trail data file",AuditList,PlatformConvert,0,DFC_FORWARD);
     clsvid();
     if (AuditOpen) {
          audfClose(auddat);
     }
     unlink("WGSAUDT3.DAT");
     unlink("GCVIRDAT\WGSAUDT3.VIR");
     
     return(0);
}

static DFCFUNCTION
PlatformDummy(                     /*  Dummy routine (no conversion needed)*/
pDFCFILEINFO from,                 /*   No conversion is needed for the    */
pDFCFILEINFO to)                   /*   platform.  File is compat w/ both  */
{
     (VOID)from;
     (VOID)to;
     return(NULL);
}

static DFCFUNCTION
AuditConvert(                      /*  Brings to most recent version       */
pDFCFILEINFO from,                 /*  Pointer to from information         */
pDFCFILEINFO to)                   /*  Pointer to TO information           */
{
     struct audOldStyle *aold;
     struct audEntry anew;

     (VOID)to;

     if (!AuditOpen) {
          unlink(AUDITFILE);
          if (audfOpen(&auddat,AUDITFILE,AUDMODE_READWRITE) < 0) {
               catastro("WGSADCVT: Unable to open %s",AUDITFILE);
          }
          AuditOpen=TRUE;
     }
     setmem(&anew,sizeof(struct audEntry),0);
     aold=(struct audOldStyle *)from->Data;

     stlcpy(anew.stamp,ConvertStamp(aold->stamp),AUDSTAMPSIZ);
     stlcpy(anew.brief,aold->brief,AUDBRIEFSIZ);
     stlcpy(anew.channel,aold->channel,AUDCHANSIZ);
     stlcpy(anew.detail,aold->detail,AUDDETSIZ);

     audfAddLowLevel(auddat,&anew,sizeof(struct audEntry));
     return(NULL);
}

static CHAR *                      /*  Pointer to new stamp format         */
ConvertStamp(                      /* Convert from old to new style        */
const CHAR *stamp)                 /*  Old style stamp                     */
{
     static CHAR NewStamp[AUDSTAMPSIZ];
     CHAR timstg[sizeof("HH:MM")];
     CHAR datstg[sizeof("MM:DD:YY")];
     CHAR NewDate[sizeof("MM:DD:YYYY")];
     CHAR NewTime[sizeof("HH:MM:SS")];

     setmem(NewStamp,AUDSTAMPSIZ,0);
     stlcpy(timstg,stamp,sizeof(timstg));
     stlcpy(datstg,stamp+sizeof(timstg),sizeof(datstg));

     sDateEncodeDOS(dcdate(datstg),NewDate,sizeof(NewDate));
     sTimeEncodeDOS(dctime(timstg),NewTime,sizeof(NewTime));

     sprintf(NewStamp,"%s %s",NewDate,NewTime);
     return(NewStamp);
}
