/***************************************************************************
 *                                                                         *
 *   UNINSTAL.C                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is a generic un-install utility that simply blasts a given       *
 *   subdirectory and all of its sub-subdirectories.                       *
 *                                                                         *
 *                                            - T. Stryker 6/2/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 6 $"

#define DIRLEN   44                /* length of directory entry windows    */
#define NSCNS     2                /* number of screens in scntbl[]        */

extern CHAR scntbl[][GVIDSCNSIZ];  /* table of screen files from MAKESCNS  */

INT exicod;                        /* errorlevel returned to DOS           */
CHAR dstspc[GCMAXPTH],*dsptr;      /* dest file spec and path-end ptr      */

VOID zapdir(CHAR *path);
VOID chk4halt(VOID);
VOID dwpath(CHAR *spc);
INT isfspc(INT c,CHAR *stg);
VOID goaway(VOID);

INT
main(
INT argc,
CHAR *argv[])
{
TRY
     CHAR dstdrv[MAXDRIVE],dstdir[GCMAXPTH];
     INT i;
     CHAR yorn[4];

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL);
          return(1);
     }
#endif // GCWINNT
     if ((exicod=setjmp(disaster)) != 0) {
          goaway();
          return(exicod);
     }
     setcrit();
     switch (argc) {
     default:
     case 2:
          color=0;
     case 1:
          stzcpy(dstspc,argv[0],GCMAXPTH);
          fnsplit(dstspc,dstdrv,dstdir,NULL,NULL);
          fnmerge(dstspc,dstdrv,dstdir,"","");
          strupr(dstspc);
          dstspc[min(DIRLEN,strlen(dstspc)-1)]='\0';
     }
     for (i=0 ; i < NSCNS ; i++) {
          cvtscn(scntbl[i]);
     }
     mem2scn(scntbl[0],0,GVIDSCNSIZ);
     explodeto(scntbl[1],0,0,48,3,(80-49)/2,1);
     explodeto(scntbl[1],0,5,47,8,7,7);
     explodeto(scntbl[1],0,18,45,20,34/2,12);
     proff(7,7);
     if (!edtval(2,2,DIRLEN+1,dstspc,isfiln,ALLCAPS+USEPOFF)) {
          goaway();
          return(exicod);
     }
     mem2scn(scntbl[0]+gvscnoff(0,12),gvscnoff(0,12),4*160);
     explodeto(scntbl[1],48,12,79,19,18,10);
     strcpy(yorn,"No");
     do {
          if (!edtval(23,5,sizeof(yorn),yorn,validyn,USEPOFF)) {
               goaway();
               return(exicod);
          }
     } while (yorn[0] == '\0');
     if (yorn[0] == 'Y') {
          explodeto(scntbl[1],48,5,79,11,23,16);
          proff(23+3,16+3);
          setwin(0L,23+3,16+3,23+3+26,16+3+1,0);
          cursiz(GVIDNOCURS);
          setatr(0x3F);
          chdir("\\");
          zapdir(dstspc);
          explodeto(scntbl[1],0,10,31,16,23,16);
     }
     goaway();
     return(exicod);
EXCEPT
#ifdef GCWINNT
     goaway();
     return(1);
#endif // GCWINNT

}

VOID
zapdir(                            /* zap a directory and everything in it */
CHAR *path)
{
     CHAR *pptr;
     struct ffblk fb;

     dwpath(path);
     pptr=path+strlen(path);
     strcpy(pptr,"*.*");
     if (fnd1st(&fb,path,FAMDIR)) {
          do {
               chk4halt();
               if ((fb.ff_attrib&FAMDIR) && fb.ff_name[0] != '.') {
                    strcpy(pptr,fb.ff_name);
                    zapdir(path);
               }
          } while (fndnxt(&fb));
     }
     strcpy(pptr,"*.*");
     if (fnd1st(&fb,path,0)) {
          do {
               chk4halt();
               strcpy(pptr,fb.ff_name);
               prat(0,0,"%-54.54s",path);
               if (unlink(path) != 0) {
                    catastro("Unable to delete \"%s\"",path);
               }
          } while (fndnxt(&fb));
     }
     *(pptr-1)='\0';
     if (!(strlen(path) == 2 && path[1] == ':')) {
          if (rmdir(path) != 0) {
               catastro("Unable to remove \"%s\"",path);
          }
     }
}

VOID
chk4halt(VOID)                     /* check for ESC entered and halt if so */
{
     if (kbhit() && getchc() == ESC) {
          setatr(0x70);
          setwin(0L,0,0,79,24,1);
          locate(23+2,16+5);
          printf(" ESC HIT: UN-INSTALL HALTED ");
          goaway();
     }
}

VOID
dwpath(                            /* deal with entered path string        */
CHAR *spc)
{
     if (strlen(spc) == 0) {
          getcwd(spc,GCMAXPTH);
     }
     if (spc[strlen(spc)-1] != '\\') {
          strcat(spc,"\\");
     }
}

INT
isfspc(                            /* returns 1 if char is valid filespec  */
INT c,
CHAR *stg)
{
     return(isfiln(c,stg) || c == ':' || c == '\\');
}

VOID
goaway(VOID)                       /* call it quits                        */
{
     locate(0,24);
     cursiz(GVIDLILCURS);
}
