/***************************************************************************
 *                                                                         *
 *   LOGMODS.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is a log of modules loaded for use with WGSERVER for DOS.        *
 *                                                                         *
 *                                        - R. Skurnick  7/11/96           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 2 $"

VOID
logmods(VOID)                 /* record all DLLs to log file               */
{
     USHORT i;
     CHAR buff[50];
     FILE *log;
     struct ffblk finfo;

     if ((log=fopen("wgserver.out",FOPWA)) != NULL) {
          fprintf(log,"\nModule Load Table: %s %s\n\n",
                         ncdate(today()),nctime(now()));
          fprintf(log,"Addr ");
          fprintf(log,"Module                      ");
          fprintf(log,"                  Date     Time         Bytes\n");
          fprintf(log,"---- ");
          fprintf(log,"----------------------------");
          fprintf(log,"----------------- -------- -------- ---------\n");
          for (i=7 ; i < 0xffff ; i+=8) {
               if (DosGetModName(i,50,buff) == 0) {
                    if (fnd1st(&finfo,buff,0)) {
                         fprintf(log,"%04x=%-45s %s %s %9ld\n",i,buff,
                                        ncdate((INT)finfo.ff_fdate),
                                        nctime((INT)finfo.ff_ftime),
                                        finfo.ff_fsize);
                    }
                    else {
                         fprintf(log,"%04x=%-45s\n",i,buff);
                    }
               }
          }
          fprintf(log,"---- ");
          fprintf(log,"----------------------------");
          fprintf(log,"----------------- -------- -------- ---------\n");
          fclose(log);
     }
}
