/***************************************************************************
 *                                                                         *
 *   ABOUTOS.C                                                             *
 *                                                                         *
 *   Copyright (C) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Operating system information routines for DOS.                        *
 *                                                                         *
 *                                        - Ilya Minkin 01/26/96           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 7 $"

VOID
aboutos(VOID)                      /* About screen repaint routine         */
{
     extern UINT maxspd;
     extern UINT maxpol;
     ULONG ravl=0L,eavl=0L;

     setatr(0x1E);
     printfat(21,8,"DOS v%d.%d",_osmajor,_osminor);
     setatr(0x1D);
     printfat(7,9,"Multitasking: ");
     setatr(0x1E);
     printf("%s %s",multsk ? "Yes -" : "No",
                   !multsk ? "" : mulmth == COMIRP ? "Interrupt" : "Timer");
     setatr(0x1D);
     printfat(7,10,"Maximum Baud: ");
     setatr(0x1E);
     if (maxspd == maxpol) {
          printf("%.8s",l2as(maxspd));
     }
     else {
          printf("%s/%s",l2as(maxspd),l2as(maxpol));
     }
     DosMemAvail(&eavl);
     setatr(0x1D);
     printfat(40,8,"Available Memory: ");
     setatr(0x1E);
     printf("%-8.8s",dbytes(eavl/1024));
     DosRealAvail(&ravl);
     setatr(0x1D);
     printfat(40,9,"<1 Meg Memory: ");
     setatr(0x1E);
     printf("%-8.8s",dbytes(ravl/1024));
}
