###############################################################################
#####    This makefile generates WGSERVER.EXE and all standard DLLs       #####
###############################################################################
!include $(WGDEV)\src\gcrules.mak

.path.c = .;.\$(OS)
.path.lib = $(TEMPDIR);$(WGLIBDIR);$(BC50)\LIB;$(DOSEXT)\BC5\LIB

LIBCMD = $(LIBCMD);$(DOSEXT)\BC5\LIB

!if $(OS) == DOS
!    if $(MODEL) == LARGE
!         error WGSERVER not supported in Large Model for DOS!
!    endif
!    if "$(DOSEXT)" == ""
!         error NO DOS EXTENDER DEFINED FOR PROTECTED MODE
!    endif
     EXELIB =            \
          $(EXELIB)      \
          $(GCSPLIB)     \
          plhide.lib     \
          galgsbl.lib    \
          galme.lib      \
          emu.lib        \
          mathh.lib      \
          phapi.lib      \
          bch286.lib
     MATHEXE = $(DOSEXT)\BC5\LIB\emu286.lib
!else
     EXELIB =            \
          $(EXELIB)      \
          galgsbl.lib    \
          $(GCSPLIB)     \
          galme.lib
     MATHEXE =
     PARSEOPTS = $(PARSEOPTS) -D__BUILDWGSERVER
!endif

DEFILE = $(TEMPDIR)\wgserver.def

VIRFILES =          \
     wgsclas2.vir   \
     wgserv2.vir    \
     wgsgen2.vir    \
     wgskey2.vir    \
     wgsmenu2.vir   \
     wgsusr2.vir    \
     wgsvbl2.vir    \
     wgsxrf2.vir    \
     wgsstat2.vir

OBJFILES =          \
     about.obj      \
     account.obj    \
     accscn.obj     \
     ain.obj        \
     audit.obj      \
     autsns.obj     \
     baduid.obj     \
     bbsgen.obj     \
     bbsrip.obj     \
     bbsutils.obj   \
     cncutl.obj     \
     dftstats.obj   \
     emulate.obj    \
     filexfer.obj   \
     fsd.obj        \
     fsdbbs.obj     \
     ftf.obj        \
     ftfascii.obj   \
     ftfkerm.obj    \
     ftfview.obj    \
     ftfxymd.obj    \
     ftfzmod.obj    \
     galfda.obj     \
     gcsasys.obj    \
     gcsgagt.obj    \
     helpscn.obj    \
     llist.obj      \
     local.obj      \
     locknkey.obj   \
     majorbbs.obj   \
     menuing.obj    \
     mnuutl.obj     \
     monitor.obj    \
     oprlow.obj     \
     page.obj       \
     protstuf.obj   \
     signup.obj     \
     statscns.obj   \
     summary.obj    \
     users.obj

!if $(OS) == DOS
     OSFILES =           \
          aboutos.obj    \
          logmods.obj    \
          plbbs.obj      \
          saputl.obj     \
          wginit.obj
     OSLIBS =            \
          plhide.lib     \
          bch286.lib     \
          phapi.lib
     RESFILES =
!else
     OSFILES =           \
          aboutos.obj    \
          callinit.obj   \
          logmods.obj    \
          majorsvc.obj   \
          majorwin.obj   \
          serial.obj     \
          wginit.obj
     OSLIBS =
     RESFILES = wgserver.res       \
                wgsmsgs.res
!endif

start:              \
     $(GCBUILD)     \
     wgserver.exe

wgserver.exe:       \
     wgsacct.h      \
     wgsfsd.h       \
     wgsftf.h       \
     wgsmajor.h     \
     wgspag.h       \
     wgssup.h       \
     wgsrip.h       \
     wgserver.h     \
     $(RESFILES)    \
     $(OBJFILES)    \
     $(OSFILES)     \
     $(OSLIBS)      \
     $(LIBNAME)     \
     $(EXELIB)      \
     $(DEFILE)      \
     $(VIRFILES)
     $(LINK) $(LIBCMD) @&&|
$(GUIEXE) $(MATHEXE) $(OBJFILES) $(OSFILES)
$(RUNDIR)\$&
$(RUNDIR)\$&
$(EXELIB) $(LINKGUI)
$(DEFILE)
|
!if $(OS) == DOS
#%if CUSTOMER
#%else
     bind286 @&&|
$(DOSEXT)\rtk\run286b.exe
$(RUNDIR)\wgserver.exe
-dll $(DOSEXT)\rtk\doscalls.dll
-exe $(RUNDIR)\wgserver.exe
|
     cfig286 $(RUNDIR)\wgserver.exe -ni 15 -istk 20 -realb 4000h -xfer 16 -ls 8192
!if $d(BUILD)
     galcopy wg.bat $(RUNDIR)
     galcopy wgsstart.bat $(RUNDIR)
     galcopy wgserv.dos $(RUNDIR)
     del $(RUNDIR)\wgsclean.mdf
!endif

nada: \
#%endif
#%if CUSTOMER
     cfig286 wgserver.exe -ni 15 -istk 20 -realb 4000h -xfer 16 -ls 8192
     if exist wgscnf.exe bind286 wgscnf.exe
     if exist wgscnf.exe cfig286 wgscnf.exe -ls 8192
     if exist wgsmtree.exe bind286 wgsmtree.exe
     if exist wgsmtree.exe cfig286 wgsmtree.exe -ls 8192
     if exist galfoman.exe bind286 galfoman.exe
     if exist galfoman.exe cfig286 galfoman.exe -ls 8192
     if exist wgsrpt.exe bind286 wgsrpt.exe
     if exist wgsrpt.exe cfig286 wgsrpt.exe -ls 8192
     if exist wgsdfcvt.exe bind286 wgsdfcvt.exe
     if exist wgsdfcvt.exe cfig286 wgsdfcvt.exe -ls 8192
#%endif
!else
     brc32 $(TEMPDIR)\wgserver.res $(RUNDIR)\wgserver.exe
     galcopy wgsclean.new $(RUNDIR)
     galcopy wgserv.nt $(RUNDIR)
# make LIBs for Visual C++ add-ons
!if $d(MSDevDir)
     galvcdef $(TEMPDIR)\wgserver.def $(TEMPDIR)\wgserver.vcd
     lib /DEF:$(TEMPDIR)\wgserver.vcd /OUT:$(WGLIBDIR)\msvc\wgserver.lib
!endif
!endif
