/***************************************************************************
 *                                                                         *
 *   STATSCNS.C                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Handler for any number of online statistic screens.                   *
 *                                                                         *
 *                                             - Chris Robert 02/28/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"
#include "statscns.h"

#define FILREV "$Revision: 5 $"

VOID vidmov(CHAR *,INT,INT,INT,INT,CHAR *,INT,INT);

static UINT stakey(UINT scncod);
static VOID stacyc(VOID),upsscn(VOID),dnsscn(VOID),prvscn(VOID),nxtscn(VOID),
            shwchc(VOID),newguy(VOID),occsta(VOID);

INT stahdl;                        /* handle for statistic screens handler */
extern INT ehdl;                   /* handle for the emulation screen      */
extern INT mhdl;                   /* handle for the monitor screen        */

struct scrnid statscn={
     "wgssta.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_T,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     dnsscn,                       /* screen going away routine            */
     upsscn,                       /* screen repaint routine               */
     stakey,                       /* key handler routine                  */
     occsta,                       /* occasional update routine            */
     60,                           /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     stacyc,                       /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     0,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

static INT fguy=0;                 /* first guy in listed choices (on scn) */
static CHAR tmpscn[GVIDSCNSIZ];    /* temporary space for new stat screens */
static INT curguy=0;               /* current stat screen on display       */
static INT uppery;                 /* upper y coord for first scn choice   */
static INT nsscns=0;               /* number of stat screens to worry about*/
static struct statsc **sscns;      /* pointers to stat interface structs   */

VOID
register_stascn(stascn)            /* register a statistic screen          */
struct statsc *stascn;
{
     if (nsscns == 0) {
          sscns=(struct statsc **)alcmem(sizeof(struct statsc *));
     }
     else {
          sscns=(struct statsc **)alcrsz(sscns,sizeof(struct statsc *)*nsscns,
                                         sizeof(struct statsc *)*(nsscns+1));
     }
     sscns[nsscns++]=stascn;
}

static
VOID
upsscn(VOID)                       /* bring up the statistic screen handler*/
{
     INT i,y=1;

     actvscn(stahdl);
     if (nsscns < 13) {
          y=1+(17-(nsscns+4))/2;
     }
     setatr(0x1B);
     printfat(1,y++," to switch");
     printfat(1,y,"");
     setatr(0x1D);
     printfat(2,y,"Stat Screens");
     setatr(0x1B);
     printfat(14,y++,"");
     printfat(1,y++,"Ķ");
     uppery=y;
     for (i=0 ; i < 13 && i < nsscns ; i++) {
          printfat(1,y,"");
          printfat(14,y++,"");
     }
     printfat(1,y++,"ͼ");
     shwchc();
     newguy();
}

static
VOID
shwchc(VOID)                       /* show the guy's current choices       */
{
     INT i,id;

     for (i=0,id=fguy ; i < 13 && i < nsscns ; i++,id++) {
          setatr(id == curguy ? 0x70 : 0x1F);
          printfat(2,i+uppery,"%-12.12s",sscns[id]->name);
     }
     if (nsscns > 13) {
          setatr(0x1B);
          if (fguy+13 == nsscns) {
               printfat(3,uppery+13,"");
          }
          else {
               printfat(3,uppery+13," (more) ");
          }
     }
}

static VOID
newguy(VOID)                       /* bring a new stat guy to the display  */
{
     VOID (*rouptr)(VOID);

     if (sscns[curguy]->filnam != NULL) {
          iniscn(sscns[curguy]->filnam,tmpscn);
          vidmov(tmpscn,15,1,56,17,actvscn(stahdl),15,1);
     }
     if ((rouptr=sscns[curguy]->inirou) != NULL) {
          (*rouptr)();
     }
}

static
VOID
prvscn(VOID)                       /* go to the prev stat screen (CRSRUP)  */
{
     if (curguy != 0) {
          if (curguy == fguy) {
               fguy--;
          }
          curguy--;
          shwchc();
          newguy();
     }
}

static
VOID
nxtscn(VOID)                       /* go to the next stat screen (CRSRDN)  */
{
     if (curguy+1 < nsscns) {
          if (curguy == fguy+12) {
               fguy++;
          }
          curguy++;
          shwchc();
          newguy();
     }
}

static VOID
dnsscn(VOID)                       /* bring down the statistic screen      */
{
     VOID (*rouptr)(VOID);

     if ((rouptr=sscns[curguy]->finrou) != NULL) {
          (*rouptr)();
     }
}

static
VOID
stacyc(VOID)                       /* once-per-cycle stat screen handler   */
{
     VOID (*rouptr)(VOID);

     if ((rouptr=sscns[curguy]->cycrou) != NULL) {
          (*rouptr)();
     }
}

static
VOID
occsta(VOID)                       /* once-every-60 secs update routine    */
{
     VOID (*rouptr)(VOID);

     if ((rouptr=sscns[curguy]->occrou) != NULL) {
          actvscn(stahdl);
          (*rouptr)();
     }
}

static
UINT
stakey(                            /* stats screen keystroke handler       */
UINT scncod)                       /* scan code for key pressed            */
{
     UINT (*rouptr)(UINT scncod);

     actvscn(stahdl);
     switch (scncod) {
     case TAB:                     /* go on to the next main screen        */
          scn2mai(mhdl);
          break;
     case BAKTAB:                  /* go back to the prev main screen      */
          scn2mai(ehdl);
          break;
     case CRSRDN:                  /* go to next stat screen               */
          nxtscn();
          break;
     case CRSRUP:                  /* go to previous stat screen           */
          prvscn();
          break;
     default:                      /* pass keypress on to someone else     */
          if ((rouptr=sscns[curguy]->keyhit) != NULL) {
               return((*rouptr)(scncod));
          }
          return(scncod);
     }
     return(0);
}
