/***************************************************************************
 *                                                                         *
 *   MAJORWIN.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Functions used for WGSERVER main GUI window.                          *
 *                                                                         *
 *                                        - I. Minkin 6/26/96              *
 *                                                                         *
 ***************************************************************************/

#ifndef __MAJORWIN_H
#define __MAJORWIN_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#include <windows.h>

typedef struct tagWGSRegInfo {     // reg information to send to GUI window
     ULONG version;                //   version number
     ULONG licenseCount;           //   WGS license count
     CHAR *regNumber;              //   WGS registration number
     CHAR *regName;                //   WGS owner name
} WGSREGINFO;

VOID                               // create console or GUI window based on
openVideoOutput(VOID);             // Registry setting

VOID
closeVideoOutput(VOID);            // shutdown GUI window if present

VOID
sendAuditTrailToMainWin(           // sends audit trail to GUI window
const CHAR *auditText,             //   text to send
const CHAR *auditTextEx);          //   text to send

VOID
sendSysopPageToMainWin(            // sends sysop page to GUI window
const CHAR *pageText);             //   text to send

VOID
sendSysLoadToMainWin(              // sends response time to GUI window
const CHAR *respTime);             //   response time

VOID
sendStatusToMainWin(               // sends status to GUI window
const CHAR *statusText);           //   status text

VOID
sendRegInfoToMainWin(              // sends registration info to GUI window
WGSREGINFO *regInfo);              //   registration info

VOID
sendWGSReadyToMainWin(VOID);       // inform GUI window that WGS is ready

GBOOL                              //   TRUE - yes
isNTShutdown(VOID);                // is NT currently shutting down

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __MAJORWIN_H
