/***************************************************************************
 *                                                                         *
 *   MAJORSVC.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Functions used by MAJORBBS.C when run as a service                    *
 *                                                                         *
 *                                        - I. Minkin 6/05/96              *
 *                                                                         *
 ***************************************************************************/

#ifndef __MAJORSVC_H
#define __MAJORSVC_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#include <windows.h>
#include "svcnames.h"
#include "elogapi.h"
#include "wgsmsgs.h"

extern INT errcod;                 // MS-DOS exit codes (for batch files)
extern GBOOL fInitComplete;        // done initializing

VOID WINAPI
serviceControl(                    // hahdle control codes from SCM
DWORD ctrlCode);                   //   control code

GBOOL                              //   return TRUE-Ok FALSE-failure
serviceInit(                       // prepare to start as a service
HANDLE *hReportTh);                //   handle to status report thread

VOID
serviceShutdown(                   // shuts down service
HANDLE hReportTh);                 //   report thread handle (or NULL)

HANDLE                             //   return new thread handle
runReportTh(                       // run status report thread
GBOOL fStarting);                  //   report START_PENDING or STOP_PENDING

VOID
terminateReportTh(                 // terminates status report thread
HANDLE hReportTh);                 //   thread handle

GBOOL                              //   return TRUE-Ok FALSE-failure
reportStatusToSCM(                 // report new status to SCM
ULONG newState,                    //   new status to report
ULONG win32ExitCode,               //   Win32 API exit code
ULONG waitHint);                   //   wait hint

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __MAJORSVC_H
