/***************************************************************************
 *                                                                         *
 *   LLIST.H                                                               *
 *                                                                         *
 *   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the generic linked list library.                              *
 *                                                                         *
 *                                       - Mahesh Neelakanta 7/6/95        *
 *                                                                         *
 ***************************************************************************/

#ifndef __LLIST_H
#define __LLIST_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct llist {
     CHAR *key;
     VOID *data;
     struct llist *next;
};

struct llist *
lladd(
CHAR *key,
VOID *data,
struct llist *list);

VOID
lldel(
CHAR *key,
struct llist *list);

VOID *
llfind(
CHAR *key,
struct llist *list);

VOID *
llfindclose(
CHAR *key,
struct llist *list);

VOID
llfree(
struct llist *list);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __LLIST_H                            */